/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ByteCountDeserializer
extends StdDeserializer<ByteCount> {
    public ByteCountDeserializer() {
        this(ByteCount.class);
    }

    protected ByteCountDeserializer(Class<?> valueClass) {
        super(valueClass);
    }

    public ByteCount deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
        String byteString = parser.getValueAsString();
        try {
            return ByteCount.parse((String)byteString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }
}

