/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareScheduledExecutorService;
import com.linecorp.armeria.common.DefaultContextAwareEventLoop;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import io.netty.channel.EventLoop;
import java.util.Objects;

public interface ContextAwareEventLoop
extends ContextAwareScheduledExecutorService,
EventLoop {
    public static ContextAwareEventLoop of(RequestContext context, EventLoop eventLoop) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(eventLoop, "eventLoop");
        if (eventLoop instanceof ContextAwareEventLoop) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareEventLoop)eventLoop, ContextAwareEventLoop.class);
            return (ContextAwareEventLoop)eventLoop;
        }
        return new DefaultContextAwareEventLoop(context, eventLoop);
    }

    @Override
    public RequestContext context();

    public EventLoop withoutContext();
}

