/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpRequestSubscriber;
import com.linecorp.armeria.client.AggregatedHttpRequestHandler;
import com.linecorp.armeria.client.ClientHttp1ObjectEncoder;
import com.linecorp.armeria.client.ClientHttp2ObjectEncoder;
import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Http1ClientKeepAliveHandler;
import com.linecorp.armeria.client.Http1ResponseDecoder;
import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpChannelPool;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.client.SessionProtocolNegotiationException;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.WebSocketHttp1ClientChannelHandler;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.outlier.OutlierDetection;
import com.linecorp.armeria.common.outlier.OutlierDetectionDecision;
import com.linecorp.armeria.common.outlier.OutlierDetector;
import com.linecorp.armeria.common.outlier.OutlierRule;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.ClosedStreamExceptionUtil;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PendingExceptionUtil;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.common.Http2GoAwayHandler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.ssl.SslCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpSessionHandler
extends ChannelDuplexHandler
implements HttpSession {
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);
    private final HttpChannelPool channelPool;
    private final Channel channel;
    private final SocketAddress remoteAddress;
    private final Promise<Channel> sessionPromise;
    private final int connectionTimeoutMillis;
    private final SessionProtocol desiredProtocol;
    private final SerializationFormat serializationFormat;
    private final HttpChannelPool.PoolKey poolKey;
    private final HttpClientFactory clientFactory;
    @Nullable
    private final OutlierDetector outlierDetector;
    @Nullable
    private final OutlierRule outlierRule;
    @Nullable
    private ScheduledFuture<?> sessionTimeoutFuture;
    @Nullable
    private SocketAddress proxyDestinationAddress;
    @Nullable
    private volatile Boolean isAcquirable;
    @Nullable
    private SessionProtocol protocol;
    @Nullable
    private HttpResponseDecoder responseDecoder;
    @Nullable
    private ClientHttpObjectEncoder requestEncoder;
    private int maxUnfinishedResponses = Integer.MAX_VALUE;
    private int numRequestsSent;
    @Nullable
    private SessionProtocol retryProtocol;
    private boolean isSettingsFrameReceived;
    private boolean channelActivated;

    HttpSessionHandler(HttpChannelPool channelPool, Channel channel, Promise<Channel> sessionPromise, int connectionTimeoutMillis, SessionProtocol desiredProtocol, SerializationFormat serializationFormat, HttpChannelPool.PoolKey poolKey, HttpClientFactory clientFactory) {
        this.channelPool = Objects.requireNonNull(channelPool, "channelPool");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.remoteAddress = channel.remoteAddress();
        this.sessionPromise = Objects.requireNonNull(sessionPromise, "sessionPromise");
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.desiredProtocol = desiredProtocol;
        this.serializationFormat = serializationFormat;
        this.poolKey = poolKey;
        this.clientFactory = clientFactory;
        OutlierDetection outlierDetection = clientFactory.options().connectionOutlierDetection();
        if (outlierDetection != OutlierDetection.disabled()) {
            this.outlierDetector = outlierDetection.newDetector();
            this.outlierRule = outlierDetection.rule();
        } else {
            this.outlierDetector = null;
            this.outlierRule = null;
        }
        if (!poolKey.proxyConfig.proxyType().isForwardProxy()) {
            this.scheduleSessionTimeout(channel, sessionPromise, connectionTimeoutMillis, desiredProtocol);
        }
    }

    private void scheduleSessionTimeout(Channel channel, Promise<Channel> sessionPromise, int connectionTimeoutMillis, SessionProtocol desiredProtocol) {
        assert (this.sessionTimeoutFuture == null) : "sessionTimeoutFuture is scheduled already.";
        this.sessionTimeoutFuture = channel.eventLoop().schedule(() -> {
            if (sessionPromise.tryFailure((Throwable)new SessionProtocolNegotiationException(desiredProtocol, "connection established, but session creation timed out. (channel: " + channel + ')'))) {
                channel.close();
            }
        }, (long)connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    @Override
    @Nullable
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.inboundTrafficController();
    }

    @Override
    public boolean hasUnfinishedResponses() {
        if (this.responseDecoder == null) {
            return false;
        }
        return this.responseDecoder.hasUnfinishedResponses();
    }

    @Override
    public boolean incrementNumUnfinishedResponses() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.reserveUnfinishedResponse(this.maxUnfinishedResponses);
    }

    @Override
    public boolean canSendRequest() {
        assert (this.responseDecoder != null);
        if (!this.channel.isActive()) {
            return false;
        }
        if (this.responseDecoder instanceof Http2ResponseDecoder) {
            Http2GoAwayHandler goAwayHandler = ((Http2ResponseDecoder)this.responseDecoder).goAwayHandler();
            return !goAwayHandler.sentGoAway() && !goAwayHandler.receivedGoAway();
        }
        return this.isAcquirable(this.responseDecoder.keepAliveHandler());
    }

    @Override
    public void invoke(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        this.applyOutlierDetection(ctx);
        if (this.handleEarlyCancellation(ctx, req, res)) {
            pooledChannel.release();
            return;
        }
        long writeTimeoutMillis = ctx.writeTimeoutMillis();
        assert (this.protocol != null);
        assert (this.requestEncoder != null);
        assert (this.responseDecoder != null);
        if (!this.protocol.isMultiplex() && !this.serializationFormat.requiresNewConnection(this.protocol)) {
            boolean useHttp1Pipelining = this.clientFactory.useHttp1Pipelining();
            CompletableFuture<Void> completionFuture = useHttp1Pipelining ? req.whenComplete() : CompletableFuture.allOf(req.whenComplete(), res.whenComplete());
            completionFuture.handle((ret, cause) -> {
                assert (this.responseDecoder != null);
                if (this.isAcquirable(this.responseDecoder.keepAliveHandler())) {
                    pooledChannel.release();
                }
                return null;
            });
        }
        try (SafeCloseable ignored = ctx.push();){
            if (!ctx.exchangeType().isRequestStreaming()) {
                AggregatedHttpRequestHandler reqHandler = new AggregatedHttpRequestHandler(this.channel, this.requestEncoder, this.responseDecoder, req, res, ctx, writeTimeoutMillis);
                req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), (EventExecutor)this.channel.eventLoop())).handle((BiFunction)reqHandler);
                return;
            }
            AbstractHttpRequestSubscriber subscriber = AbstractHttpRequestSubscriber.of(this.channel, this.requestEncoder, this.responseDecoder, this.protocol, ctx, req, res, writeTimeoutMillis, this.isWebSocket());
            req.subscribe(subscriber, (EventExecutor)this.channel.eventLoop(), SubscriptionOption.WITH_POOLED_OBJECTS);
        }
    }

    private boolean isWebSocket() {
        return this.serializationFormat == SerializationFormat.WS;
    }

    @Override
    public int incrementAndGetNumRequestsSent() {
        return ++this.numRequestsSent;
    }

    private boolean handleEarlyCancellation(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (res.isOpen()) {
            return false;
        }
        assert (this.responseDecoder != null);
        this.responseDecoder.decrementUnfinishedResponses();
        assert (this.protocol != null);
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            req.abort(CancelledSubscriptionException.get());
            ctx.logBuilder().session(this.channel, this.protocol, null);
            ctx.logBuilder().requestHeaders(req.headers());
            req.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endRequest();
                } else {
                    ctx.logBuilder().endRequest((Throwable)cause);
                }
                return null;
            });
            res.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endResponse();
                } else {
                    ctx.logBuilder().endResponse((Throwable)cause);
                }
                return null;
            });
        }
        return true;
    }

    @Override
    public void retryWith(SessionProtocol protocol) {
        this.retryProtocol = protocol;
    }

    @Override
    public boolean isAcquirable() {
        assert (this.responseDecoder != null);
        return this.isAcquirable(this.responseDecoder.keepAliveHandler());
    }

    @Override
    public boolean isAcquirable(KeepAliveHandler keepAliveHandler) {
        Boolean isAcquirable = this.isAcquirable;
        if (isAcquirable == null || !isAcquirable.booleanValue()) {
            return false;
        }
        return !keepAliveHandler.needsDisconnection();
    }

    @Override
    public void markUnacquirable() {
        this.isAcquirable = false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelActivated = this.channel.isActive();
        if (this.isAcquirable == null) {
            this.isAcquirable = this.channelActivated;
        }
        this.tryCompleteSessionPromise(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelActivated = true;
        if (this.isAcquirable == null) {
            this.isAcquirable = true;
        }
        this.tryCompleteSessionPromise(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2Settings) {
            Long maxConcurrentStreams = ((Http2Settings)msg).maxConcurrentStreams();
            this.maxUnfinishedResponses = maxConcurrentStreams != null ? (maxConcurrentStreams > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxConcurrentStreams.intValue()) : Integer.MAX_VALUE;
            this.isSettingsFrameReceived = true;
            this.tryCompleteSessionPromise(ctx);
            return;
        }
        try {
            String typeInfo = msg instanceof ByteBuf ? msg + " HexDump: " + ByteBufUtil.hexDump((ByteBuf)((ByteBuf)msg)) : String.valueOf(msg);
            throw new IllegalStateException("unexpected message type: " + typeInfo + " (expected: ByteBuf)");
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release((Object)msg);
            throw throwable;
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SessionProtocol) {
            SessionProtocol protocol;
            assert (this.protocol == null);
            assert (this.responseDecoder == null);
            this.protocol = protocol = (SessionProtocol)((Object)evt);
            if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
                HttpResponseDecoder responseDecoder = this.isWebSocket() ? (HttpResponseDecoder)ctx.pipeline().get(WebSocketHttp1ClientChannelHandler.class) : (HttpResponseDecoder)ctx.pipeline().get(Http1ResponseDecoder.class);
                KeepAliveHandler keepAliveHandler = responseDecoder.keepAliveHandler();
                keepAliveHandler.initialize(ctx);
                ClientHttp1ObjectEncoder requestEncoder = new ClientHttp1ObjectEncoder(this.channel, protocol, this.clientFactory.http1HeaderNaming(), keepAliveHandler, this.isWebSocket());
                if (keepAliveHandler instanceof Http1ClientKeepAliveHandler) {
                    ((Http1ClientKeepAliveHandler)keepAliveHandler).setEncoder(requestEncoder);
                }
                this.requestEncoder = requestEncoder;
                this.responseDecoder = responseDecoder;
            } else if (protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) {
                ChannelHandlerContext connectionHandlerCtx = ctx.pipeline().context(Http2ClientConnectionHandler.class);
                Http2ClientConnectionHandler connectionHandler = (Http2ClientConnectionHandler)connectionHandlerCtx.handler();
                this.requestEncoder = new ClientHttp2ObjectEncoder(connectionHandlerCtx, connectionHandler, protocol);
                this.responseDecoder = connectionHandler.responseDecoder();
            } else {
                throw new Error();
            }
            this.tryCompleteSessionPromise(ctx);
            return;
        }
        if (evt instanceof SessionProtocolNegotiationException) {
            this.tryFailSessionPromise((Throwable)evt);
            ctx.close();
            return;
        }
        if (evt instanceof SslCompletionEvent) {
            SslCompletionEvent sslCompletionEvent = (SslCompletionEvent)evt;
            if (!sslCompletionEvent.isSuccess()) {
                Throwable handshakeException = sslCompletionEvent.cause();
                Throwable pendingException = PendingExceptionUtil.getPendingException(ctx);
                if (pendingException != null && handshakeException != pendingException) {
                    pendingException.addSuppressed(handshakeException);
                    handshakeException = pendingException;
                }
                this.tryFailSessionPromise(handshakeException);
                ctx.close();
            }
            return;
        }
        if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        if (evt instanceof ProxyConnectionEvent) {
            this.proxyDestinationAddress = ((ProxyConnectionEvent)evt).destinationAddress();
            if (!this.tryCompleteSessionPromise(ctx) && this.poolKey.proxyConfig.proxyType().isForwardProxy()) {
                this.scheduleSessionTimeout(this.channel, this.sessionPromise, this.connectionTimeoutMillis, this.desiredProtocol);
            }
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)this.channel, evt);
    }

    private boolean tryCompleteSessionPromise(ChannelHandlerContext ctx) {
        if (this.protocol == null || !this.channelActivated) {
            return false;
        }
        if (this.poolKey.proxyConfig.proxyType() != ProxyType.DIRECT && this.proxyDestinationAddress == null) {
            return false;
        }
        if (this.protocol.isExplicitHttp2() && !this.isSettingsFrameReceived) {
            return false;
        }
        if (this.sessionTimeoutFuture != null) {
            this.sessionTimeoutFuture.cancel(false);
        }
        if (!this.sessionPromise.trySuccess((Object)this.channel) && !this.sessionPromise.isSuccess()) {
            ctx.close();
        }
        return true;
    }

    private void tryFailSessionPromise(Throwable cause) {
        if (this.sessionTimeoutFuture != null) {
            this.sessionTimeoutFuture.cancel(false);
        }
        if (!this.sessionPromise.isDone()) {
            this.sessionPromise.tryFailure(cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = false;
        if (this.retryProtocol != null) {
            assert (this.responseDecoder == null || !this.responseDecoder.hasUnfinishedResponses());
            if (this.sessionTimeoutFuture != null) {
                this.sessionTimeoutFuture.cancel(false);
            }
            if (this.proxyDestinationAddress != null) {
                this.channelPool.connect(this.proxyDestinationAddress, this.retryProtocol, this.serializationFormat, this.poolKey, this.sessionPromise, null);
            } else {
                this.channelPool.connect(this.remoteAddress, this.retryProtocol, this.serializationFormat, this.poolKey, this.sessionPromise, null);
            }
        } else {
            ClosedSessionException pendingException;
            HttpResponseDecoder responseDecoder = this.responseDecoder;
            if (responseDecoder != null && responseDecoder.hasUnfinishedResponses()) {
                pendingException = ClosedStreamExceptionUtil.newClosedSessionException(ctx);
                responseDecoder.failUnfinishedResponses(pendingException);
            } else {
                pendingException = null;
            }
            this.tryFailSessionPromise(pendingException != null ? pendingException : ClosedStreamExceptionUtil.newClosedSessionException(ctx));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ProxyConnectException) {
            SessionProtocol protocol = this.protocol != null ? this.protocol : this.desiredProtocol;
            UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
            this.channelPool.maybeHandleProxyFailure(protocol, this.poolKey, wrapped);
            this.tryFailSessionPromise(wrapped);
            return;
        }
        PendingExceptionUtil.setPendingException(ctx, (Throwable)new ClosedSessionException(cause));
        if (!(cause instanceof IOException)) {
            ctx.close();
        }
    }

    private void applyOutlierDetection(ClientRequestContext ctx) {
        if (this.outlierRule == null || !this.isAcquirable()) {
            return;
        }
        assert (this.outlierDetector != null);
        if (this.outlierDetector.isOutlier()) {
            return;
        }
        ctx.log().whenComplete().thenAccept(this::detectOutlier);
    }

    private void detectOutlier(RequestLog log) {
        OutlierDetectionDecision decision;
        RequestContext context = log.context();
        ContextAwareEventLoop eventLoop = context.eventLoop();
        if (!eventLoop.inEventLoop()) {
            eventLoop.execute(() -> this.detectOutlier(log));
            return;
        }
        assert (this.outlierRule != null);
        try {
            decision = this.outlierRule.decide(context, log.responseHeaders(), log.responseCause());
        }
        catch (Exception e) {
            logger.warn("Unexpected exception from an OutlierDetectingRule: {}", (Object)this.outlierRule, (Object)e);
            return;
        }
        if (decision == null) {
            return;
        }
        assert (this.outlierDetector != null);
        switch (decision) {
            case SUCCESS: 
            case NEXT: {
                this.outlierDetector.onSuccess();
                if (!this.outlierDetector.isOutlier()) break;
                this.markUnacquirable();
                break;
            }
            case FAILURE: {
                this.outlierDetector.onFailure();
                if (!this.outlierDetector.isOutlier()) break;
                this.markUnacquirable();
                break;
            }
            case FATAL: {
                this.markUnacquirable();
                break;
            }
        }
    }
}

