/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.utils;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.Exemplar;
import org.opensearch.dataprepper.model.metric.JacksonHistogram;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.metric.JacksonStandardHistogram;
import org.opensearch.dataprepper.model.metric.JacksonSum;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCommonUtils;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ClientSpanDecoration;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.HistogramBuckets;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.MetricAggregationState;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.MetricKey;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.SpanStateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApmServiceMapMetricsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ApmServiceMapMetricsUtil.class);
    private static final List<Double> EXPLICIT_BOUNDS = List.of(0.0, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0);

    public static void generateMetricsForClientSpan(SpanStateData clientSpan, ClientSpanDecoration decoration, Instant currentTime, Map<MetricKey, MetricAggregationState> metricsStateByKey, Instant anchorTimestamp) {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("namespace", "span_derived");
        labels.put("environment", clientSpan.getEnvironment());
        labels.put("service", clientSpan.getServiceName());
        labels.put("operation", decoration.getParentServerOperationName());
        labels.put("remoteEnvironment", decoration.getRemoteEnvironment());
        labels.put("remoteService", decoration.getRemoteService());
        labels.put("remoteOperation", decoration.getRemoteOperation());
        labels.putAll(clientSpan.getGroupByAttributes());
        MetricKey metricKey = new MetricKey(labels, anchorTimestamp);
        MetricAggregationState state = metricsStateByKey.computeIfAbsent(metricKey, k -> new MetricAggregationState());
        state.incrementRequestCount(1L);
        Long durationInNanos = clientSpan.getDurationInNanos();
        if (durationInNanos != null && durationInNanos > 0L) {
            double durationInSeconds = (double)durationInNanos.longValue() / 1.0E9;
            state.addLatencyDuration(durationInSeconds);
        }
        state.incrementErrorCount(clientSpan.getError());
        state.incrementFaultCount(clientSpan.getFault());
        if (clientSpan.getError() == 1 && state.getErrorExemplars().size() < 10) {
            state.addErrorExemplar(ApmServiceMapMetricsUtil.createExemplarFromSpan(clientSpan, state.getErrorCount()));
        }
        if (clientSpan.getFault() == 1 && state.getFaultExemplars().size() < 10) {
            state.addFaultExemplar(ApmServiceMapMetricsUtil.createExemplarFromSpan(clientSpan, state.getFaultCount()));
        }
    }

    public static void generateMetricsForServerSpan(SpanStateData serverSpan, Instant currentTime, Map<MetricKey, MetricAggregationState> metricsStateByKey, Instant anchorTimestamp) {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("namespace", "span_derived");
        labels.put("environment", serverSpan.getEnvironment());
        labels.put("service", serverSpan.getServiceName());
        labels.put("operation", serverSpan.getOperationName());
        labels.putAll(serverSpan.getGroupByAttributes());
        MetricKey metricKey = new MetricKey(labels, anchorTimestamp);
        MetricAggregationState state = metricsStateByKey.computeIfAbsent(metricKey, k -> new MetricAggregationState());
        state.incrementRequestCount(1L);
        Long durationInNanos = serverSpan.getDurationInNanos();
        if (durationInNanos != null && durationInNanos > 0L) {
            double durationInSeconds = (double)durationInNanos.longValue() / 1.0E9;
            state.addLatencyDuration(durationInSeconds);
        }
        state.incrementErrorCount(serverSpan.getError());
        state.incrementFaultCount(serverSpan.getFault());
        if (serverSpan.getError() == 1 && state.getErrorExemplars().size() < 10) {
            state.addErrorExemplar(ApmServiceMapMetricsUtil.createExemplarFromSpan(serverSpan, state.getErrorCount()));
        }
        if (serverSpan.getFault() == 1 && state.getFaultExemplars().size() < 10) {
            state.addFaultExemplar(ApmServiceMapMetricsUtil.createExemplarFromSpan(serverSpan, state.getFaultCount()));
        }
    }

    public static List<JacksonMetric> createMetricsFromAggregatedState(Map<MetricKey, MetricAggregationState> metricsStateByKey) {
        ArrayList<JacksonMetric> metrics = new ArrayList<JacksonMetric>();
        for (Map.Entry<MetricKey, MetricAggregationState> entry : metricsStateByKey.entrySet()) {
            MetricKey metricKey = entry.getKey();
            MetricAggregationState state = entry.getValue();
            metrics.add(ApmServiceMapMetricsUtil.createJacksonSumMetric("request", "Number of requests", state.getRequestCount(), metricKey.getLabels(), metricKey.getTimestamp(), Collections.emptyList()));
            metrics.add(ApmServiceMapMetricsUtil.createJacksonSumMetric("error", "Number of error requests", state.getErrorCount(), metricKey.getLabels(), metricKey.getTimestamp(), state.getErrorExemplars()));
            metrics.add(ApmServiceMapMetricsUtil.createJacksonSumMetric("fault", "Number of fault requests", state.getFaultCount(), metricKey.getLabels(), metricKey.getTimestamp(), state.getFaultExemplars()));
            if (state.getLatencyDurations().isEmpty()) continue;
            metrics.add(ApmServiceMapMetricsUtil.createJacksonStandardHistogram("latency_seconds", "Request latency in seconds", state.getLatencyDurations(), metricKey.getLabels(), metricKey.getTimestamp()));
        }
        metrics.sort(Comparator.comparing(JacksonMetric::getTime));
        return metrics;
    }

    static Exemplar createExemplarFromSpan(SpanStateData spanStateData, double value) {
        try {
            String traceId = spanStateData.getTraceId();
            String spanId = spanStateData.getSpanId();
            long timestampNanos = ApmServiceMapMetricsUtil.getTimeNanos(Instant.now());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("service.name", spanStateData.getServiceName());
            attributes.put("operation.name", spanStateData.getOperationName());
            if (spanStateData.getStatus() != null) {
                attributes.put("status", spanStateData.getStatus());
            }
            return new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)timestampNanos), Double.valueOf(value), spanId, traceId, attributes);
        }
        catch (Exception e) {
            LOG.debug("Failed to create exemplar from span: {}", (Object)e.getMessage());
            return new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)ApmServiceMapMetricsUtil.getTimeNanos(Instant.now())), Double.valueOf(value), null, null, Collections.emptyMap());
        }
    }

    static JacksonMetric createJacksonSumMetric(String metricName, String description, double value, Map<String, Object> labels, Instant timestamp, List<Exemplar> exemplars) {
        long timestampNanos;
        long startTimeNanos = timestampNanos = ApmServiceMapMetricsUtil.getTimeNanos(timestamp);
        HashMap<String, Object> labelsWithRandomKey = new HashMap<String, Object>();
        labelsWithRandomKey.putAll(labels);
        labelsWithRandomKey.put("randomKey", UUID.randomUUID().toString());
        return ((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)JacksonSum.builder().withName(metricName)).withDescription(description)).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)timestampNanos))).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)startTimeNanos))).withIsMonotonic(true).withUnit("1")).withAggregationTemporality("AGGREGATION_TEMPORALITY_DELTA").withValue(Double.valueOf(value)).withExemplars(exemplars)).withAttributes(labelsWithRandomKey)).build(false);
    }

    static JacksonMetric createJacksonStandardHistogram(String metricName, String description, List<Double> durations, Map<String, Object> labels, Instant timestamp) {
        long timestampNanos;
        long startTimeNanos = timestampNanos = ApmServiceMapMetricsUtil.getTimeNanos(timestamp);
        HistogramBuckets buckets = ApmServiceMapMetricsUtil.createHistogramBucketsFromDurations(durations);
        HashMap<String, Object> labelsWithRandomKey = new HashMap<String, Object>();
        labelsWithRandomKey.putAll(labels);
        labelsWithRandomKey.put("randomKey", UUID.randomUUID().toString());
        return ((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)JacksonStandardHistogram.builder().withName(metricName)).withDescription(description)).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)timestampNanos))).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)startTimeNanos))).withUnit("s")).withAggregationTemporality("AGGREGATION_TEMPORALITY_DELTA").withCount((long)durations.size()).withSum(durations.stream().mapToDouble(Double::doubleValue).sum()).withMin(Double.valueOf(durations.stream().mapToDouble(Double::doubleValue).min().orElse(0.0))).withMax(Double.valueOf(durations.stream().mapToDouble(Double::doubleValue).max().orElse(0.0))).withBucketCountsList(buckets.getBucketCounts()).withExplicitBoundsList(buckets.getExplicitBounds()).withBucketCount(buckets.getBucketCounts().size()).withExplicitBoundsCount(buckets.getExplicitBounds().size()).withAttributes(labelsWithRandomKey)).build(false);
    }

    static HistogramBuckets createHistogramBucketsFromDurations(List<Double> durations) {
        ArrayList<Long> bucketCounts = new ArrayList<Long>(Collections.nCopies(EXPLICIT_BOUNDS.size() + 1, 0L));
        for (Double duration : durations) {
            if (duration == null) continue;
            int bucketIndex = 0;
            for (int i = 0; i < EXPLICIT_BOUNDS.size(); ++i) {
                if (duration <= EXPLICIT_BOUNDS.get(i)) {
                    bucketIndex = i;
                    break;
                }
                bucketIndex = EXPLICIT_BOUNDS.size();
            }
            bucketCounts.set(bucketIndex, (Long)bucketCounts.get(bucketIndex) + 1L);
        }
        return new HistogramBuckets(bucketCounts, EXPLICIT_BOUNDS);
    }

    private ApmServiceMapMetricsUtil() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    private static long getTimeNanos(Instant time) {
        long NANO_MULTIPLIER = 1000000000L;
        long currentTimeNanos = time.getEpochSecond() * 1000000000L + (long)time.getNano();
        return currentTimeNanos;
    }
}

