/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map;

import com.google.common.primitives.SignedBytes;
import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.SingleThread;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventBuilder;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.peerforwarder.RequiresPeerForwarding;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.OTelApmServiceMapProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.Node;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.NodeOperationDetail;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.Operation;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ClientSpanDecoration;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.EphemeralSpanDecorations;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.MetricAggregationState;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.MetricKey;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ServerSpanDecoration;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.SpanStateData;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ThreeWindowTraceData;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model.internal.ThreeWindowTraceDataWithDecorations;
import org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.utils.ApmServiceMapMetricsUtil;
import org.opensearch.dataprepper.plugins.processor.state.MapDbProcessorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingleThread
@DataPrepperPlugin(name="otel_apm_service_map", pluginType=Processor.class, pluginConfigurationType=OTelApmServiceMapProcessorConfig.class)
public class OTelApmServiceMapProcessor
extends AbstractProcessor<Record<Event>, Record<Event>>
implements RequiresPeerForwarding {
    private static final String SPANS_DB_SIZE = "spansDbSize";
    private static final String SPANS_DB_COUNT = "spansDbCount";
    private static final Logger LOG = LoggerFactory.getLogger(OTelApmServiceMapProcessor.class);
    private static final String EVENT_TYPE_OTEL_APM_SERVICE_MAP = "SERVICE_MAP";
    private static final Collection<Record<Event>> EMPTY_COLLECTION = Collections.emptySet();
    private static final String SPAN_KIND_SERVER = "SPAN_KIND_SERVER";
    private static final String SPAN_KIND_CLIENT = "SPAN_KIND_CLIENT";
    private static final String NODE_TYPE_SERVICE = "service";
    private static final AtomicInteger processorsCreated = new AtomicInteger(0);
    private static Instant previousTimestamp;
    private static Duration windowDuration;
    private static CyclicBarrier allThreadsCyclicBarrier;
    private static volatile MapDbProcessorState<Collection<SpanStateData>> previousWindow;
    private static volatile MapDbProcessorState<Collection<SpanStateData>> currentWindow;
    private static volatile MapDbProcessorState<Collection<SpanStateData>> nextWindow;
    private static File dbPath;
    private static Clock clock;
    private final int thisProcessorId;
    private final List<String> groupByAttributes;
    private final EventFactory eventFactory;

    @DataPrepperPluginConstructor
    public OTelApmServiceMapProcessor(OTelApmServiceMapProcessorConfig config, PluginMetrics pluginMetrics, EventFactory eventFactory, PipelineDescription pipelineDescription) {
        this(config.getWindowDuration(), new File(config.getDbPath()), Clock.systemUTC(), pipelineDescription.getNumberOfProcessWorkers(), eventFactory, pluginMetrics, config.getGroupByAttributes());
    }

    OTelApmServiceMapProcessor(Duration windowDuration, File databasePath, Clock clock, int processWorkers, EventFactory eventFactory, PluginMetrics pluginMetrics) {
        this(windowDuration, databasePath, clock, processWorkers, eventFactory, pluginMetrics, Collections.emptyList());
    }

    OTelApmServiceMapProcessor(Duration windowDuration, File databasePath, Clock clock, int processWorkers, EventFactory eventFactory, PluginMetrics pluginMetrics, List<String> groupByAttributes) {
        super(pluginMetrics);
        this.groupByAttributes = groupByAttributes != null ? Collections.unmodifiableList(groupByAttributes) : Collections.emptyList();
        this.eventFactory = eventFactory;
        OTelApmServiceMapProcessor.clock = clock;
        this.thisProcessorId = processorsCreated.getAndIncrement();
        if (this.isMasterInstance()) {
            previousTimestamp = OTelApmServiceMapProcessor.clock.instant();
            OTelApmServiceMapProcessor.windowDuration = windowDuration;
            dbPath = OTelApmServiceMapProcessor.createPath(databasePath);
            currentWindow = new MapDbProcessorState(dbPath, this.getNewDbName(), processWorkers);
            previousWindow = new MapDbProcessorState(dbPath, this.getNewDbName() + "-previous", processWorkers);
            nextWindow = new MapDbProcessorState(dbPath, this.getNewDbName() + "-next", processWorkers);
            allThreadsCyclicBarrier = new CyclicBarrier(processWorkers);
        }
        pluginMetrics.gauge(SPANS_DB_SIZE, (Object)this, processor -> processor.getSpansDbSize());
        pluginMetrics.gauge(SPANS_DB_COUNT, (Object)this, processor -> processor.getSpansDbCount());
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        Collection<Record<Event>> apmEvents = this.windowDurationHasPassed() ? this.evaluateApmEvents() : EMPTY_COLLECTION;
        TreeMap batchStateData = new TreeMap(SignedBytes.lexicographicalComparator());
        records.forEach(i -> this.processSpan((Span)i.getData(), batchStateData));
        try {
            for (Map.Entry entry : batchStateData.entrySet()) {
                byte[] traceId = (byte[])entry.getKey();
                Collection spansForTrace = (Collection)entry.getValue();
                HashSet existingSpans = (HashSet)nextWindow.get(traceId);
                if (existingSpans == null) {
                    existingSpans = new HashSet();
                }
                existingSpans.addAll(spansForTrace);
                nextWindow.put(traceId, existingSpans);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Caught exception trying to put batch state data", (Throwable)e);
        }
        return apmEvents;
    }

    public void prepareForShutdown() {
        previousTimestamp = Instant.EPOCH;
    }

    public boolean isReadyForShutdown() {
        return currentWindow.size() == 0L;
    }

    public void shutdown() {
        previousWindow.delete();
        currentWindow.delete();
        if (nextWindow != null) {
            nextWindow.delete();
        }
        processorsCreated.set(0);
        allThreadsCyclicBarrier.reset();
    }

    public double getSpansDbSize() {
        return currentWindow.sizeInBytes() + previousWindow.sizeInBytes() + (nextWindow != null ? nextWindow.sizeInBytes() : 0L);
    }

    public double getSpansDbCount() {
        return currentWindow.size() + previousWindow.size() + (nextWindow != null ? nextWindow.size() : 0L);
    }

    public Collection<String> getIdentificationKeys() {
        return Collections.singleton("traceId");
    }

    private static File createPath(File path) {
        if (!path.exists() && !path.mkdirs()) {
            throw new RuntimeException(String.format("Unable to create the directory at the provided path: %s", path.getName()));
        }
        return path;
    }

    private void processSpan(Span span, Map<byte[], Collection<SpanStateData>> batchStateData) {
        if (span.getServiceName() != null) {
            String serviceName = span.getServiceName();
            String spanId = span.getSpanId();
            String traceId = span.getTraceId();
            String parentSpanId = span.getParentSpanId();
            String spanKind = span.getKind();
            String spanName = span.getName();
            String operation = span.getName();
            Long durationInNanos = span.getDurationInNanos();
            String status = this.extractSpanStatus(span);
            String endTime = span.getEndTime();
            Map<String, String> groupByAttrs = this.extractGroupByAttributes(span);
            Map<String, Object> spanAttributes = this.extractSpanAttributes(span);
            try {
                SpanStateData spanStateData = new SpanStateData(serviceName, spanId, parentSpanId.isEmpty() ? null : parentSpanId, traceId, spanKind, spanName, operation, durationInNanos, status, endTime, groupByAttrs, spanAttributes);
                Collection spansForTrace = batchStateData.computeIfAbsent(Hex.decodeHex((String)traceId), k -> new HashSet());
                spansForTrace.add(spanStateData);
            }
            catch (Exception e) {
                LOG.error("Caught exception trying to put span state data into batch", (Throwable)e);
            }
        }
    }

    private String extractSpanStatus(Span span) {
        try {
            Object code;
            Map status = span.getStatus();
            if (status != null && status.containsKey("code") && (code = status.get("code")) != null) {
                return code.toString();
            }
        }
        catch (Exception e) {
            LOG.debug("Error extracting span status: {}", (Object)e.getMessage());
        }
        return "OK";
    }

    private Map<String, Object> extractSpanAttributes(Span span) {
        try {
            Map scope;
            Map resource;
            HashMap<String, Object> combinedAttributes = new HashMap<String, Object>();
            Map attributes = span.getAttributes();
            if (attributes != null) {
                combinedAttributes.putAll(attributes);
            }
            if ((resource = span.getResource()) != null) {
                combinedAttributes.put("resource", resource);
            }
            if ((scope = span.getScope()) != null) {
                Map scopeAttributes = (Map)scope.get("attributes");
                if (attributes != null) {
                    combinedAttributes.putAll(scopeAttributes);
                }
            }
            return combinedAttributes;
        }
        catch (Exception e) {
            LOG.debug("Error extracting span attributes: {}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    private Collection<Record<Event>> evaluateApmEvents() {
        LOG.debug("Evaluating APM service map events with three-window semantics");
        try {
            allThreadsCyclicBarrier.await();
            HashSet<Record<Event>> apmEvents = new HashSet();
            if (this.isMasterInstance()) {
                apmEvents = this.processCurrentWindowSpans();
                this.rotateWindows();
            }
            allThreadsCyclicBarrier.await();
            return apmEvents;
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<Record<Event>> processCurrentWindowSpans() {
        HashSet<Record<Event>> apmEvents = new HashSet<Record<Event>>();
        Instant currentTime = clock.instant();
        EphemeralSpanDecorations ephemeralDecorations = new EphemeralSpanDecorations();
        HashMap<MetricKey, MetricAggregationState> metricsStateByKey = new HashMap<MetricKey, MetricAggregationState>();
        Map<String, Collection<SpanStateData>> previousSpansByTraceId = this.buildSpansByTraceIdMap(previousWindow);
        Map<String, Collection<SpanStateData>> currentSpansByTraceId = this.buildSpansByTraceIdMap(currentWindow);
        Map<String, Collection<SpanStateData>> nextSpansByTraceId = this.buildSpansByTraceIdMap(nextWindow);
        for (String traceId : currentSpansByTraceId.keySet()) {
            ThreeWindowTraceDataWithDecorations traceData = this.buildThreeWindowTraceDataWithDecorations(traceId, previousSpansByTraceId, currentSpansByTraceId, nextSpansByTraceId, ephemeralDecorations);
            if (traceData.getProcessingSpans().isEmpty()) continue;
            this.decorateSpansInTraceWithEphemeralStorage(traceData);
            apmEvents.addAll(this.generateNodeOperationDetailEvents(traceData, currentTime, metricsStateByKey));
        }
        List<JacksonMetric> metrics = ApmServiceMapMetricsUtil.createMetricsFromAggregatedState(metricsStateByKey);
        metrics.sort(Comparator.comparing(JacksonMetric::getTime));
        ArrayList<Record<Event>> apmEventsSorted = new ArrayList<Record<Event>>();
        apmEventsSorted.addAll(metrics.stream().map(metric -> new Record(metric)).collect(Collectors.toList()));
        apmEventsSorted.addAll(apmEvents);
        return apmEventsSorted;
    }

    private Map<String, String> extractGroupByAttributes(Span span) {
        if (this.groupByAttributes == null || this.groupByAttributes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Map resource = span.getResource();
            if (resource == null) {
                return Collections.emptyMap();
            }
            Object attributesObject = resource.get("attributes");
            if (!(attributesObject instanceof Map)) {
                return Collections.emptyMap();
            }
            Map resourceAttributes = (Map)attributesObject;
            for (String attrKey : this.groupByAttributes) {
                Object value = resourceAttributes.get(attrKey);
                if (value == null) continue;
                result.put(attrKey, value.toString());
            }
        }
        catch (Exception e) {
            LOG.debug("Error extracting group by attributes from span resource: {}", (Object)e.getMessage());
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    private Instant getAnchorTimestampFromSpan(SpanStateData spanStateData, Instant fallbackTime) {
        Instant timestamp = fallbackTime;
        String endTime = spanStateData.getEndTime();
        try {
            if (endTime != null && !endTime.isEmpty()) {
                timestamp = Instant.parse(endTime);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to parse span endTime '{}', using fallback time: {}", (Object)endTime, (Object)e.getMessage());
        }
        return timestamp.truncatedTo(ChronoUnit.MINUTES);
    }

    private void rotateWindows() throws InterruptedException {
        LOG.debug("Rotating APM service map windows at " + clock.instant().toString());
        MapDbProcessorState<Collection<SpanStateData>> tempWindow = previousWindow;
        previousWindow = currentWindow;
        currentWindow = nextWindow;
        nextWindow = tempWindow;
        nextWindow.clear();
        previousTimestamp = clock.instant();
        LOG.debug("Done rotating APM service map windows - All metrics cleared for new window");
    }

    private String getNewDbName() {
        return "apm-db-" + clock.millis();
    }

    private boolean windowDurationHasPassed() {
        Duration elapsed = Duration.between(previousTimestamp, clock.instant());
        return elapsed.compareTo(windowDuration) >= 0;
    }

    private boolean isMasterInstance() {
        return this.thisProcessorId == 0;
    }

    private Map<String, Collection<SpanStateData>> buildSpansByTraceIdMap(MapDbProcessorState<Collection<SpanStateData>> window) {
        HashMap<String, Collection<SpanStateData>> spansByTraceId = new HashMap<String, Collection<SpanStateData>>();
        if (window != null && window.getAll() != null && window.size() > 0L) {
            try {
                window.getIterator(processorsCreated.get(), this.thisProcessorId).forEachRemaining(entry -> {
                    String traceId = Hex.encodeHexString((byte[])((byte[])entry.getKey()));
                    Collection spans = (Collection)entry.getValue();
                    if (spans != null && !spans.isEmpty()) {
                        spansByTraceId.put(traceId, spans);
                    }
                });
            }
            catch (NoSuchElementException e) {
                LOG.debug("Window is empty, skipping iteration: {}", (Object)e.getMessage());
            }
        }
        return spansByTraceId;
    }

    private ThreeWindowTraceData buildThreeWindowTraceData(String traceId, Map<String, Collection<SpanStateData>> previousSpansByTraceId, Map<String, Collection<SpanStateData>> currentSpansByTraceId, Map<String, Collection<SpanStateData>> nextSpansByTraceId) {
        Collection previousSpans = previousSpansByTraceId.getOrDefault(traceId, Collections.emptyList());
        Collection processingSpans = currentSpansByTraceId.getOrDefault(traceId, Collections.emptyList());
        Collection nextSpans = nextSpansByTraceId.getOrDefault(traceId, Collections.emptyList());
        HashSet<SpanStateData> lookupSpans = new HashSet<SpanStateData>();
        lookupSpans.addAll(previousSpans);
        lookupSpans.addAll(processingSpans);
        lookupSpans.addAll(nextSpans);
        HashMap<String, SpanStateData> spansBySpanId = new HashMap<String, SpanStateData>();
        HashMap<String, Collection<SpanStateData>> childrenByParentId = new HashMap<String, Collection<SpanStateData>>();
        HashSet<String> processingSpanIds = new HashSet<String>();
        for (SpanStateData spanStateData : lookupSpans) {
            String spanId = spanStateData.getSpanId();
            spansBySpanId.put(spanId, spanStateData);
            if (spanStateData.getParentSpanId() == null) continue;
            String parentSpanId = spanStateData.getParentSpanId();
            childrenByParentId.computeIfAbsent(parentSpanId, k -> new HashSet()).add(spanStateData);
        }
        for (SpanStateData spanStateData : processingSpans) {
            processingSpanIds.add(spanStateData.getSpanId());
        }
        return new ThreeWindowTraceData(processingSpans, lookupSpans, spansBySpanId, childrenByParentId, processingSpanIds);
    }

    private ThreeWindowTraceDataWithDecorations buildThreeWindowTraceDataWithDecorations(String traceId, Map<String, Collection<SpanStateData>> previousSpansByTraceId, Map<String, Collection<SpanStateData>> currentSpansByTraceId, Map<String, Collection<SpanStateData>> nextSpansByTraceId, EphemeralSpanDecorations decorations) {
        ThreeWindowTraceData baseTraceData = this.buildThreeWindowTraceData(traceId, previousSpansByTraceId, currentSpansByTraceId, nextSpansByTraceId);
        return new ThreeWindowTraceDataWithDecorations(baseTraceData.getProcessingSpans(), baseTraceData.getLookupSpans(), baseTraceData.getSpansBySpanId(), baseTraceData.getChildrenByParentId(), baseTraceData.getProcessingSpanIds(), decorations);
    }

    private void decorateSpansInTraceWithEphemeralStorage(ThreeWindowTraceDataWithDecorations traceData) {
        this.decorateClientSpansFirstPassWithEphemeralStorage(traceData);
        this.decorateServerSpansSecondPassWithEphemeralStorage(traceData);
    }

    private void decorateClientSpansFirstPassWithEphemeralStorage(ThreeWindowTraceDataWithDecorations traceData) {
        for (SpanStateData clientSpan : traceData.getLookupSpans()) {
            if (!SPAN_KIND_CLIENT.equals(clientSpan.getSpanKind())) continue;
            String clientSpanId = clientSpan.getSpanId();
            Collection childServerSpans = ((Collection)traceData.getChildrenByParentId().getOrDefault(clientSpanId, Collections.emptyList())).stream().filter(span -> SPAN_KIND_SERVER.equals(span.getSpanKind())).collect(Collectors.toList());
            String remoteService = "unknown";
            String remoteOperation = "unknown";
            String remoteEnvironment = "generic:default";
            Map<String, String> remoteGroupByAttributes = Collections.emptyMap();
            if (!childServerSpans.isEmpty()) {
                SpanStateData childServerSpan = (SpanStateData)childServerSpans.iterator().next();
                remoteService = childServerSpan.getServiceName();
                remoteOperation = childServerSpan.getOperationName();
                remoteEnvironment = childServerSpan.getEnvironment();
                remoteGroupByAttributes = childServerSpan.getGroupByAttributes();
            }
            ClientSpanDecoration decoration = new ClientSpanDecoration(null, remoteEnvironment, remoteService, remoteOperation, remoteGroupByAttributes);
            traceData.getDecorations().setClientDecoration(clientSpanId, decoration);
        }
    }

    private void decorateServerSpansSecondPassWithEphemeralStorage(ThreeWindowTraceDataWithDecorations traceData) {
        for (SpanStateData serverSpan : traceData.getLookupSpans()) {
            if (!SPAN_KIND_SERVER.equals(serverSpan.getSpanKind())) continue;
            Collection<SpanStateData> clientDescendants = this.findClientDescendantsForServerThreeWindow(serverSpan, traceData);
            ServerSpanDecoration serverDecoration = new ServerSpanDecoration(clientDescendants);
            traceData.getDecorations().setServerDecoration(serverSpan.getSpanId(), serverDecoration);
            for (SpanStateData clientSpan : clientDescendants) {
                String clientSpanId = clientSpan.getSpanId();
                ClientSpanDecoration existingDecoration = traceData.getDecorations().getClientDecoration(clientSpanId);
                if (existingDecoration != null) {
                    ClientSpanDecoration updatedDecoration = new ClientSpanDecoration(serverSpan.getOperationName(), existingDecoration.getRemoteEnvironment(), existingDecoration.getRemoteService(), existingDecoration.getRemoteOperation(), existingDecoration.getRemoteGroupByAttributes());
                    traceData.getDecorations().setClientDecoration(clientSpanId, updatedDecoration);
                    continue;
                }
                ClientSpanDecoration newDecoration = new ClientSpanDecoration(serverSpan.getOperationName(), clientSpan.getEnvironment(), "unknown", "unknown", Collections.emptyMap());
                traceData.getDecorations().setClientDecoration(clientSpanId, newDecoration);
            }
        }
    }

    private Collection<Record<Event>> generateNodeOperationDetailEvents(ThreeWindowTraceDataWithDecorations traceData, Instant currentTime, Map<MetricKey, MetricAggregationState> metricsStateByKey) {
        Operation sourceOp;
        HashSet<Record<Event>> events = new HashSet<Record<Event>>();
        for (SpanStateData clientSpan : traceData.getProcessingSpans()) {
            ClientSpanDecoration decoration;
            if (!SPAN_KIND_CLIENT.equals(clientSpan.getSpanKind()) || (decoration = traceData.getDecorations().getClientDecoration(clientSpan.getSpanId())) == null || "unknown".equals(decoration.getRemoteService())) continue;
            Node sourceNode = new Node(NODE_TYPE_SERVICE, new Node.KeyAttributes(clientSpan.getEnvironment(), clientSpan.getServiceName()), clientSpan.getGroupByAttributes());
            Node targetNode = new Node(NODE_TYPE_SERVICE, new Node.KeyAttributes(decoration.getRemoteEnvironment(), decoration.getRemoteService()), decoration.getRemoteGroupByAttributes());
            sourceOp = decoration.getParentServerOperationName() != null ? new Operation(decoration.getParentServerOperationName()) : null;
            Operation targetOp = new Operation(decoration.getRemoteOperation());
            Instant anchorTimestamp = this.getAnchorTimestampFromSpan(clientSpan, currentTime);
            NodeOperationDetail nodeOperationDetail = new NodeOperationDetail(sourceNode, targetNode, sourceOp, targetOp, anchorTimestamp);
            DefaultEventMetadata eventMetadata = new DefaultEventMetadata.Builder().withEventType(EVENT_TYPE_OTEL_APM_SERVICE_MAP).build();
            Event event = ((EventBuilder)this.eventFactory.eventBuilder(EventBuilder.class)).withEventMetadata((EventMetadata)eventMetadata).withData((Object)nodeOperationDetail).build();
            events.add((Record<Event>)new Record((Object)event));
            if (decoration.getParentServerOperationName() == null) continue;
            ApmServiceMapMetricsUtil.generateMetricsForClientSpan(clientSpan, decoration, currentTime, metricsStateByKey, anchorTimestamp);
        }
        for (SpanStateData serverSpan : traceData.getProcessingSpans()) {
            if (!SPAN_KIND_SERVER.equals(serverSpan.getSpanKind())) continue;
            Instant anchorTimestamp = this.getAnchorTimestampFromSpan(serverSpan, currentTime);
            ApmServiceMapMetricsUtil.generateMetricsForServerSpan(serverSpan, currentTime, metricsStateByKey, anchorTimestamp);
            ServerSpanDecoration decoration = traceData.getDecorations().getServerDecoration(serverSpan.getSpanId());
            if (decoration != null && !decoration.getClientDescendants().isEmpty()) continue;
            Node sourceNode = new Node(NODE_TYPE_SERVICE, new Node.KeyAttributes(serverSpan.getEnvironment(), serverSpan.getServiceName()), serverSpan.getGroupByAttributes());
            sourceOp = new Operation(serverSpan.getOperationName());
            NodeOperationDetail nodeOperationDetail = new NodeOperationDetail(sourceNode, null, sourceOp, null, anchorTimestamp);
            DefaultEventMetadata eventMetadata = new DefaultEventMetadata.Builder().withEventType(EVENT_TYPE_OTEL_APM_SERVICE_MAP).build();
            Event event = ((EventBuilder)this.eventFactory.eventBuilder(EventBuilder.class)).withEventMetadata((EventMetadata)eventMetadata).withData((Object)nodeOperationDetail).build();
            events.add((Record<Event>)new Record((Object)event));
        }
        return events;
    }

    private Collection<SpanStateData> findClientDescendantsForServerThreeWindow(SpanStateData serverSpan, ThreeWindowTraceData traceData) {
        HashSet<SpanStateData> clientDescendants = new HashSet<SpanStateData>();
        String serverSpanId = serverSpan.getSpanId();
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.offer(serverSpanId);
        visited.add(serverSpanId);
        while (!queue.isEmpty()) {
            String currentSpanId = (String)queue.poll();
            Collection children = traceData.getChildrenByParentId().getOrDefault(currentSpanId, Collections.emptyList());
            for (SpanStateData child : children) {
                String childSpanId = child.getSpanId();
                if (visited.contains(childSpanId)) continue;
                visited.add(childSpanId);
                if (!serverSpan.getServiceName().equals(child.getServiceName())) continue;
                if (SPAN_KIND_CLIENT.equals(child.getSpanKind())) {
                    clientDescendants.add(child);
                }
                queue.offer(childSpanId);
            }
        }
        return clientDescendants;
    }
}

