/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceAddressPortAttributesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAddressPortAttributesProvider.class);
    private static final String HOST_PORT_ORDERED_LIST_FILE = "hostport_attributes_ordered_list";
    List<AddressPortAttributeKeys> addressPortAttributeKeys;

    public ServiceAddressPortAttributesProvider() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(HOST_PORT_ORDERED_LIST_FILE);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            this.addressPortAttributeKeys = reader.lines().filter(line -> line.contains(",")).map(this::getAddressPortAttributeKeys).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.addressPortAttributeKeys = null;
            LOG.error("An exception occurred while initializing hostport attribute list for Data Prepper", (Throwable)e);
        }
    }

    public List<AddressPortAttributeKeys> getAddressPortAttributeKeysList() {
        return this.addressPortAttributeKeys;
    }

    private AddressPortAttributeKeys getAddressPortAttributeKeys(String str) {
        return new AddressPortAttributeKeys(str);
    }

    public static class AddressPortAttributeKeys {
        final String address;
        final String port;

        public AddressPortAttributeKeys(String str) {
            String[] fields = str.split(",");
            if (fields.length != 2) {
                throw new RuntimeException("Invalid address-port string");
            }
            this.address = fields[0];
            this.port = fields[1];
        }

        public String getAddress() {
            return this.address;
        }

        public String getPort() {
            return this.port;
        }
    }
}

