/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.common;

import java.util.Map;
import org.opensearch.dataprepper.plugins.otel.common.OTelSpanDerivationUtil;
import org.opensearch.dataprepper.plugins.otel.common.RemoteOperationAndService;
import org.opensearch.dataprepper.plugins.otel.common.RemoteOperationServiceExtractor;

class RemoteOperationAndServiceProviders {
    public final PeerServiceRemoteOperationServiceExtractor PeerServiceRemoteOperationServiceExtractor = new PeerServiceRemoteOperationServiceExtractor();
    public final GraphQlRemoteOperationServiceExtractor GraphQlRemoteOperationServiceExtractor = new GraphQlRemoteOperationServiceExtractor();
    public final MessagingSystemRemoteOperationServiceExtractor MessagingSystemRemoteOperationServiceExtractor = new MessagingSystemRemoteOperationServiceExtractor();
    public final FaasRemoteOperationServiceExtractor FaasRemoteOperationServiceExtractor = new FaasRemoteOperationServiceExtractor();
    public final DbRemoteOperationServiceExtractor DbRemoteOperationServiceExtractor = new DbRemoteOperationServiceExtractor();
    public final DbQueryRemoteOperationServiceExtractor DbQueryRemoteOperationServiceExtractor = new DbQueryRemoteOperationServiceExtractor();
    public final AwsRpcRemoteOperationServiceExtractor AwsRpcRemoteOperationServiceExtractor = new AwsRpcRemoteOperationServiceExtractor();

    RemoteOperationAndServiceProviders() {
    }

    private static boolean appliesToSpan(Map<String, Object> spanAttributes, String attribute1) {
        return OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute1) != null;
    }

    private static boolean appliesToSpan(Map<String, Object> spanAttributes, String attribute1, String attribute2) {
        return OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute1) != null || OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute2) != null;
    }

    private static boolean appliesToSpan(Map<String, Object> spanAttributes, String attribute1, String attribute2, String attribute3) {
        return OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute1) != null || OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute2) != null || OTelSpanDerivationUtil.getStringAttribute(spanAttributes, attribute3) != null;
    }

    public static class AwsRpcRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "rpc.service", "rpc.method");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object awsServiceMappings) {
            String remoteService = null;
            String rpcService = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "rpc.service");
            String rpcSystem = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "rpc.system");
            if (rpcSystem != null && rpcSystem.equals("aws-api") && awsServiceMappings != null) {
                remoteService = (String)((Object)((Map)awsServiceMappings).getOrDefault(rpcService, "AWS::" + rpcService));
            }
            return new RemoteOperationAndService(OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "rpc.method"), remoteService);
        }
    }

    public static class DbQueryRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "db.system.name", "db.operation.name", "db.query.text");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            String remoteOperation = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.operation.name");
            if (remoteOperation == null) {
                remoteOperation = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.query.text");
            }
            if (remoteOperation != null) {
                remoteOperation = remoteOperation.trim().split("\\s+")[0].toUpperCase();
            }
            return new RemoteOperationAndService(remoteOperation, OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.system.name"));
        }
    }

    public static class DbRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "db.system", "db.operation", "db.statment");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            String remoteOperation = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.operation");
            if (remoteOperation == null) {
                remoteOperation = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.statement");
            }
            if (remoteOperation != null) {
                remoteOperation = remoteOperation.trim().split("\\s+")[0].toUpperCase();
            }
            return new RemoteOperationAndService(remoteOperation, OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "db.system"));
        }
    }

    public static class FaasRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "faas.invoked_name", "faas.trigger");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            return new RemoteOperationAndService(OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "faas.trigger"), OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "faas.invoked_name"));
        }
    }

    public static class MessagingSystemRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "messaging.system", "messaging.operation");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            return new RemoteOperationAndService(OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "messaging.operation"), OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "messaging.system"));
        }
    }

    public static class GraphQlRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "graphql.operation.type");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            String graphQLOperation = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "graphql.operation.type");
            if (graphQLOperation != null) {
                return new RemoteOperationAndService(graphQLOperation, "graphql");
            }
            return new RemoteOperationAndService(null, null);
        }
    }

    public static class PeerServiceRemoteOperationServiceExtractor
    implements RemoteOperationServiceExtractor {
        @Override
        public boolean appliesToSpan(Map<String, Object> spanAttributes) {
            return RemoteOperationAndServiceProviders.appliesToSpan(spanAttributes, "peer.service");
        }

        @Override
        public RemoteOperationAndService getRemoteOperationAndService(Map<String, Object> spanAttributes, Object optionalArg) {
            return new RemoteOperationAndService(null, OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "peer.service"));
        }
    }
}

