/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.otel.common.ServiceMappingsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AwsServiceMappingsProvider
implements ServiceMappingsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AwsServiceMappingsProvider.class);
    private static final String SERVICE_MAPPINGS_FILE = "aws_service_mappings";
    private Map<String, String> serviceMappings;

    public AwsServiceMappingsProvider() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(SERVICE_MAPPINGS_FILE);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            this.serviceMappings = reader.lines().filter(line -> line.contains(",")).collect(Collectors.toMap(line -> line.split(",", 2)[0].trim(), line -> line.split(",", 2)[1].trim(), (oldValue, newValue) -> newValue));
        }
        catch (Exception e) {
            LOG.error("An exception occurred while initializing service mappings for Data Prepper", (Throwable)e);
            this.serviceMappings = null;
        }
    }

    @Override
    public Map<String, String> getServiceMappings() {
        return this.serviceMappings;
    }
}

