/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsFormatOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsInputCodecConfig;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsJsonDecoder;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsProtoBufDecoder;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;

@DataPrepperPlugin(name="otel_logs", pluginType=InputCodec.class, pluginConfigurationType=OTelLogsInputCodecConfig.class)
public class OTelLogsInputCodec
implements InputCodec {
    private final ByteDecoder decoder;

    @DataPrepperPluginConstructor
    public OTelLogsInputCodec(OTelLogsInputCodecConfig config) {
        Objects.requireNonNull(config);
        OTelLogsFormatOption format = config.getFormat();
        OTelOutputFormat otelFormat = config.getOTelOutputFormat();
        if (format == OTelLogsFormatOption.JSON) {
            this.decoder = new OTelLogsJsonDecoder(otelFormat);
        } else if (format == OTelLogsFormatOption.PROTOBUF) {
            this.decoder = new OTelLogsProtoBufDecoder(otelFormat, config.getLengthPrefixedEncoding());
        } else {
            throw new RuntimeException("The codec " + String.valueOf((Object)config.getFormat()) + " is not supported.");
        }
    }

    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        this.decoder.parse(inputStream, null, eventConsumer);
    }
}

