/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs.http;

import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ConsumesProtobuf;
import com.linecorp.armeria.server.annotation.Post;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.exceptions.BadRequestException;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmeriaHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(ArmeriaHttpService.class);
    public static final String REQUESTS_RECEIVED = "requestsReceived";
    public static final String SUCCESS_REQUESTS = "successRequests";
    public static final String PAYLOAD_SIZE = "payloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private final OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder;
    private final Buffer<Record<Object>> buffer;
    private final int bufferWriteTimeoutInMillis;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;

    public ArmeriaHttpService(Buffer<Record<Object>> buffer, PluginMetrics pluginMetrics, int bufferWriteTimeoutInMillis, OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder) {
        this.buffer = buffer;
        this.oTelProtoDecoder = oTelProtoDecoder;
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
        this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
        this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
        this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
    }

    @Post(value="")
    @ConsumesJson
    @ConsumesProtobuf
    public ExportLogsServiceResponse exportLog(ExportLogsServiceRequest request) {
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)request.getSerializedSize());
        this.requestProcessDuration.record(() -> this.processRequest(request));
        return ExportLogsServiceResponse.newBuilder().build();
    }

    private void processRequest(ExportLogsServiceRequest request) {
        List logs;
        try {
            logs = this.oTelProtoDecoder.parseExportLogsServiceRequest(request, Instant.now());
        }
        catch (Exception e) {
            LOG.warn(DataPrepperMarkers.SENSITIVE, "Failed to parse the request with error {}. Request body: {}", (Object)e, (Object)request);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.buffer.isByteBuffer()) {
                this.buffer.writeBytes(request.toByteArray(), null, this.bufferWriteTimeoutInMillis);
            } else {
                List records = logs.stream().map(log -> new Record(log)).collect(Collectors.toList());
                this.buffer.writeAll(records, this.bufferWriteTimeoutInMillis);
            }
        }
        catch (Exception e) {
            if (ServiceRequestContext.current().isTimedOut()) {
                LOG.warn("Exception writing to buffer but request already timed out.", (Throwable)e);
                return;
            }
            LOG.error("Failed to write the request of size {} due to:", (Object)request.toString().length(), (Object)e);
            throw new BufferWriteException(e.getMessage(), (Throwable)e);
        }
        if (ServiceRequestContext.current().isTimedOut()) {
            LOG.warn("Buffer write completed successfully but request already timed out.");
            return;
        }
        this.successRequestsCounter.increment();
    }
}

