/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardFailure;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardStatistics
implements PlainJsonSerializable {
    @Nonnull
    private final Number failed;
    @Nonnull
    private final List<ShardFailure> failures;
    @Nullable
    private final Number skipped;
    @Nonnull
    private final Number successful;
    @Nonnull
    private final Number total;
    public static final JsonpDeserializer<ShardStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStatistics::setupShardStatisticsDeserializer);

    private ShardStatistics(Builder builder) {
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.skipped = builder.skipped;
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, this, "successful");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static ShardStatistics of(Function<Builder, ObjectBuilder<ShardStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Number failed() {
        return this.failed;
    }

    @Nonnull
    public final List<ShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Number skipped() {
        return this.skipped;
    }

    @Nonnull
    public final Number successful() {
        return this.successful;
    }

    @Nonnull
    public final Number total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failed");
        generator.write(this.failed.doubleValue());
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.skipped != null) {
            generator.writeKey("skipped");
            generator.write(this.skipped.doubleValue());
        }
        generator.writeKey("successful");
        generator.write(this.successful.doubleValue());
        generator.writeKey("total");
        generator.write(this.total.doubleValue());
    }

    protected static void setupShardStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failed, JsonpDeserializer.numberDeserializer(), "failed");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
        op.add(Builder::skipped, JsonpDeserializer.numberDeserializer(), "skipped");
        op.add(Builder::successful, JsonpDeserializer.numberDeserializer(), "successful");
        op.add(Builder::total, JsonpDeserializer.numberDeserializer(), "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.failed.hashCode();
        result = 31 * result + Objects.hashCode(this.failures);
        result = 31 * result + Objects.hashCode(this.skipped);
        result = 31 * result + this.successful.hashCode();
        result = 31 * result + this.total.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStatistics other = (ShardStatistics)o;
        return this.failed.equals(other.failed) && Objects.equals(this.failures, other.failures) && Objects.equals(this.skipped, other.skipped) && this.successful.equals(other.successful) && this.total.equals(other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardStatistics> {
        private Number failed;
        @Nullable
        private List<ShardFailure> failures;
        @Nullable
        private Number skipped;
        private Number successful;
        private Number total;

        public final Builder failed(Number value) {
            this.failed = value;
            return this;
        }

        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        public final Builder skipped(@Nullable Number value) {
            this.skipped = value;
            return this;
        }

        public final Builder successful(Number value) {
            this.successful = value;
            return this;
        }

        public final Builder total(Number value) {
            this.total = value;
            return this;
        }

        @Override
        public ShardStatistics build() {
            this._checkSingleUse();
            return new ShardStatistics(this);
        }
    }
}

