/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartition;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotFoundException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotOwnedException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionUpdateException;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchIndexProgressState;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.SearchConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.OpenSearchIndexPartitionCreationSupplier;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.SearchWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.WorkerCommonUtils;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.exceptions.IndexNotFoundException;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.NoSearchContextSearchRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchWithSearchAfterResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSearchContextWorker
implements SearchWorker,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(NoSearchContextWorker.class);
    private final ObjectMapper objectMapper;
    private final SearchAccessor searchAccessor;
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator;
    private final BufferAccumulator<Record<Event>> bufferAccumulator;
    private final OpenSearchIndexPartitionCreationSupplier openSearchIndexPartitionCreationSupplier;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics;
    private int noAvailableIndicesCount = 0;

    public NoSearchContextWorker(ObjectMapper objectMapper, SearchAccessor searchAccessor, OpenSearchSourceConfiguration openSearchSourceConfiguration, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator, BufferAccumulator<Record<Event>> bufferAccumulator, OpenSearchIndexPartitionCreationSupplier openSearchIndexPartitionCreationSupplier, AcknowledgementSetManager acknowledgementSetManager, OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics) {
        this.objectMapper = objectMapper;
        this.searchAccessor = searchAccessor;
        this.sourceCoordinator = sourceCoordinator;
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.bufferAccumulator = bufferAccumulator;
        this.openSearchIndexPartitionCreationSupplier = openSearchIndexPartitionCreationSupplier;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.openSearchSourcePluginMetrics = openSearchSourcePluginMetrics;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Optional indexPartition = this.sourceCoordinator.getNextPartition((Function)this.openSearchIndexPartitionCreationSupplier);
                if (indexPartition.isEmpty()) {
                    try {
                        Thread.sleep(WorkerCommonUtils.calculateExponentialBackoffAndJitter(++this.noAvailableIndicesCount));
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.info("The search_after worker was interrupted while sleeping after acquiring no indices to process, stopping processing");
                        return;
                    }
                }
                this.noAvailableIndicesCount = 0;
                try {
                    AcknowledgementSet acknowledgementSet = WorkerCommonUtils.createAcknowledgmentSet(this.acknowledgementSetManager, this.openSearchSourceConfiguration, this.sourceCoordinator, (SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()));
                    this.openSearchSourcePluginMetrics.getIndexProcessingTimeTimer().record(() -> this.processIndex((SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()), acknowledgementSet));
                    WorkerCommonUtils.completeIndexPartition(this.openSearchSourceConfiguration, acknowledgementSet, (SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()), this.sourceCoordinator);
                    this.openSearchSourcePluginMetrics.getIndicesProcessedCounter().increment();
                    LOG.info("Completed processing for index: '{}'", (Object)((SourcePartition)indexPartition.get()).getPartitionKey());
                }
                catch (PartitionNotFoundException | PartitionNotOwnedException | PartitionUpdateException e) {
                    LOG.warn("The search_after worker received an exception from the source coordinator. There is a potential for duplicate data for index {}, giving up partition and getting next partition: {}", (Object)((SourcePartition)indexPartition.get()).getPartitionKey(), (Object)e.getMessage());
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)indexPartition.get()).getPartitionKey());
                }
                catch (IndexNotFoundException e) {
                    LOG.warn("{}, marking index as complete and continuing processing", (Object)e.getMessage());
                    this.sourceCoordinator.completePartition(((SourcePartition)indexPartition.get()).getPartitionKey(), Boolean.valueOf(false));
                }
                catch (Exception e) {
                    LOG.error("Unknown exception while processing index '{}', moving on to another index:", (Object)((SourcePartition)indexPartition.get()).getPartitionKey(), (Object)e);
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)indexPartition.get()).getPartitionKey());
                    this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                }
            }
            catch (Exception e) {
                this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                LOG.error("Received an exception while trying to get index to process with search_after, backing off and retrying", (Throwable)e);
                try {
                    Thread.sleep(WorkerCommonUtils.BACKOFF_ON_EXCEPTION.toMillis());
                }
                catch (InterruptedException ex) {
                    LOG.info("The search_after worker was interrupted before backing off and retrying, stopping processing");
                    return;
                }
            }
        }
    }

    private void processIndex(SourcePartition<OpenSearchIndexProgressState> openSearchIndexPartition, AcknowledgementSet acknowledgementSet) {
        String indexName = openSearchIndexPartition.getPartitionKey();
        long lastCheckpointTime = System.currentTimeMillis();
        LOG.info("Started processing for index: '{}'", (Object)indexName);
        Optional<OpenSearchIndexProgressState> openSearchIndexProgressStateOptional = openSearchIndexPartition.getPartitionState();
        if (openSearchIndexProgressStateOptional.isEmpty()) {
            openSearchIndexProgressStateOptional = Optional.of(this.initializeProgressState());
        }
        OpenSearchIndexProgressState openSearchIndexProgressState = (OpenSearchIndexProgressState)openSearchIndexProgressStateOptional.get();
        SearchConfiguration searchConfiguration = this.openSearchSourceConfiguration.getSearchConfiguration();
        SearchWithSearchAfterResults searchWithSearchAfterResults = null;
        do {
            searchWithSearchAfterResults = this.searchAccessor.searchWithoutSearchContext(NoSearchContextSearchRequest.builder().withIndex(indexName).withPaginationSize(searchConfiguration.getBatchSize()).withSearchAfter(this.getSearchAfter(openSearchIndexProgressState, searchWithSearchAfterResults)).build());
            searchWithSearchAfterResults.getDocuments().stream().map(Record::new).forEach(record -> {
                try {
                    long documentBytes = this.objectMapper.writeValueAsBytes((Object)((Event)record.getData()).getJsonNode()).length;
                    this.openSearchSourcePluginMetrics.getBytesReceivedSummary().record((double)documentBytes);
                    if (Objects.nonNull(acknowledgementSet)) {
                        acknowledgementSet.add((Event)record.getData());
                    }
                    this.bufferAccumulator.add(record);
                    this.openSearchSourcePluginMetrics.getDocumentsProcessedCounter().increment();
                    this.openSearchSourcePluginMetrics.getBytesProcessedSummary().record((double)documentBytes);
                }
                catch (Exception e) {
                    this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                    LOG.error("Failed writing OpenSearch documents to buffer. The last document created has document id '{}' from index '{}' : {}", new Object[]{((Event)record.getData()).getMetadata().getAttribute("opensearch-document_id"), ((Event)record.getData()).getMetadata().getAttribute("opensearch-index"), e.getMessage()});
                }
            });
            openSearchIndexProgressState.setSearchAfter(searchWithSearchAfterResults.getNextSearchAfter());
            if (System.currentTimeMillis() - lastCheckpointTime <= 300000L) continue;
            LOG.debug("Renew ownership of index {}", (Object)indexName);
            this.sourceCoordinator.saveProgressStateForPartition(indexName, (Object)openSearchIndexProgressState);
            lastCheckpointTime = System.currentTimeMillis();
        } while (searchWithSearchAfterResults.getDocuments().size() == searchConfiguration.getBatchSize().intValue());
        LOG.info("Received {} documents in latest search request, and batch size is {}, exiting pagination", (Object)searchWithSearchAfterResults.getDocuments().size(), (Object)searchConfiguration.getBatchSize());
        try {
            this.bufferAccumulator.flush();
        }
        catch (Exception e) {
            this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
            LOG.error("Failed writing remaining OpenSearch documents to buffer due to: {}", (Object)e.getMessage());
        }
    }

    private OpenSearchIndexProgressState initializeProgressState() {
        return new OpenSearchIndexProgressState();
    }

    private List<String> getSearchAfter(OpenSearchIndexProgressState openSearchIndexProgressState, SearchWithSearchAfterResults searchWithSearchAfterResults) {
        if (Objects.isNull(searchWithSearchAfterResults)) {
            if (Objects.isNull(openSearchIndexProgressState.getSearchAfter())) {
                return null;
            }
            return openSearchIndexProgressState.getSearchAfter();
        }
        return searchWithSearchAfterResults.getNextSearchAfter();
    }
}

