/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.s3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.FileReader;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.FileType;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.InvalidS3URIException;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.S3ObjectTooLargeException;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.UnsupportedFileTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class S3FileReader
implements FileReader {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileReader.class);
    static final long ONE_MB = 0x100000L;
    private static final long FIVE_MB = 0x500000L;
    private static final String MAX_CONTENT_LENGTH = "5 MB";
    private final S3Client s3Client;

    public S3FileReader(S3Client s3Client) {
        this.s3Client = Objects.requireNonNull(s3Client);
    }

    public ResponseInputStream<GetObjectResponse> readFile(String filePath) {
        try {
            URI fileUri = new URI(filePath);
            this.validateURI(fileUri);
            this.validateFileType(filePath);
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(fileUri.getHost()).key(fileUri.getPath().substring(1)).build();
            ResponseInputStream responseInputStream = this.s3Client.getObject(getObjectRequest);
            this.validateS3ObjectSize((ResponseInputStream<GetObjectResponse>)responseInputStream, fileUri);
            return responseInputStream;
        }
        catch (URISyntaxException ex) {
            LOG.error("Error encountered while parsing the Amazon S3 URI in OpenSearch sink.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private void validateURI(URI fileUri) {
        String bucketName = fileUri.getHost();
        String objectKey = fileUri.getPath();
        if (bucketName == null || objectKey.length() < 2) {
            throw new InvalidS3URIException("S3 URi must contain valid bucket and object key name");
        }
    }

    private void validateFileType(String filePath) {
        int index = filePath.lastIndexOf(".");
        String fileType = null;
        if (index != -1) {
            fileType = filePath.substring(index).substring(1);
        }
        if (!EnumUtils.isValidEnumIgnoreCase(FileType.class, fileType)) {
            throw new UnsupportedFileTypeException("S3 file type provided is not supported");
        }
    }

    private void validateS3ObjectSize(ResponseInputStream<GetObjectResponse> responseInputStream, URI uri) {
        Long contentLength = ((GetObjectResponse)responseInputStream.response()).contentLength();
        if (contentLength > 0x500000L) {
            throw new S3ObjectTooLargeException(String.format("S3 object content length can't be more than %s. %s object size is %s bytes", MAX_CONTENT_LENGTH, uri.getPath().substring(1), contentLength));
        }
    }
}

