/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.sink.opensearch.DistributionVersion;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ActionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.AwsAuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexConstants;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.model.QueryForExistingDocumentConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.S3ClientProvider;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.S3FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.s3.S3Client;

public class IndexConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(IndexConfiguration.class);
    private static final String ACTION_ON_FOUND_DROP = "drop";
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String SETTINGS = "settings";
    public static final String INDEX_ALIAS = "index";
    public static final String INDEX_TYPE = "index_type";
    public static final String TEMPLATE_TYPE = "template_type";
    public static final String TEMPLATE_FILE = "template_file";
    public static final String TEMPLATE_CONTENT = "template_content";
    public static final String NUM_SHARDS = "number_of_shards";
    public static final String NUM_REPLICAS = "number_of_replicas";
    public static final String BULK_SIZE = "bulk_size";
    public static final String ESTIMATE_BULK_SIZE_USING_COMPRESSION = "estimate_bulk_size_using_compression";
    public static final String MAX_LOCAL_COMPRESSIONS_FOR_ESTIMATION = "max_local_compressions_for_estimation";
    public static final String FLUSH_TIMEOUT = "flush_timeout";
    public static final String DOCUMENT_ID_FIELD = "document_id_field";
    public static final String DOCUMENT_ID = "document_id";
    public static final String ROUTING_FIELD = "routing_field";
    public static final String ROUTING = "routing";
    public static final String PIPELINE = "pipeline";
    public static final String ISM_POLICY_FILE = "ism_policy_file";
    public static final String ACTION = "action";
    public static final String ACTIONS = "actions";
    public static final String SERVERLESS = "serverless";
    public static final String DISTRIBUTION_VERSION = "distribution_version";
    public static final String AWS_OPTION = "aws";
    public static final String DOCUMENT_ROOT_KEY = "document_root_key";
    public static final String DOCUMENT_VERSION_EXPRESSION = "document_version";
    private IndexType indexType;
    private TemplateType templateType;
    private final String indexAlias;
    private final Map<String, Object> indexTemplate;
    private final String documentIdField;
    private final String documentId;
    private final String routingField;
    private final String routing;
    private final long bulkSize;
    private final boolean estimateBulkSizeUsingCompression;
    private int maxLocalCompressionsForEstimation;
    private final long flushTimeout;
    private final Optional<String> ismPolicyFile;
    private final String action;
    private final List<ActionConfiguration> actions;
    private final String s3AwsRegion;
    private final String s3AwsStsRoleArn;
    private final String s3AwsExternalId;
    private final S3Client s3Client;
    private final boolean serverless;
    private final DistributionVersion distributionVersion;
    private final String documentRootKey;
    private final String versionExpression;
    private final VersionType versionType;
    private final boolean normalizeIndex;
    private final String queryWhen;
    private final Duration queryDuration;
    private final String queryTerm;
    private final String queryActionOnFound;
    private final boolean queryOnBulkFailures;
    private final Integer queryAsyncDocumentLimit;
    private static final String S3_PREFIX = "s3://";

    private IndexConfiguration(Builder builder) {
        this.serverless = builder.serverless;
        this.distributionVersion = builder.distributionVersion;
        this.determineIndexType(builder);
        this.s3AwsRegion = builder.s3AwsRegion;
        this.s3AwsStsRoleArn = builder.s3AwsStsRoleArn;
        this.s3AwsExternalId = builder.s3AwsStsExternalId;
        this.s3Client = builder.s3Client;
        this.versionExpression = builder.versionExpression;
        this.versionType = builder.versionType;
        this.normalizeIndex = builder.normalizeIndex;
        this.queryOnBulkFailures = builder.queryOnIndexingFailure;
        this.determineTemplateType(builder);
        Map<String, Object> map = this.indexTemplate = builder.templateContent != null ? this.readTemplateContent(builder.templateContent) : this.readIndexTemplate(builder.templateFile, this.indexType, this.templateType);
        if (builder.numReplicas > 0) {
            this.indexTemplate.putIfAbsent(SETTINGS, new HashMap());
            ((Map)this.indexTemplate.get(SETTINGS)).putIfAbsent(NUM_REPLICAS, builder.numReplicas);
        }
        if (builder.numShards > 0) {
            this.indexTemplate.putIfAbsent(SETTINGS, new HashMap());
            ((Map)this.indexTemplate.get(SETTINGS)).putIfAbsent(NUM_SHARDS, builder.numShards);
        }
        String indexAlias = builder.indexAlias;
        if (IndexConstants.TYPE_TO_DEFAULT_ALIAS.containsKey((Object)this.indexType)) {
            indexAlias = IndexConstants.TYPE_TO_DEFAULT_ALIAS.get((Object)this.indexType);
        } else if (indexAlias == null) {
            throw new IllegalStateException("Missing required properties:indexAlias");
        }
        this.indexAlias = indexAlias;
        this.bulkSize = builder.bulkSize;
        this.estimateBulkSizeUsingCompression = builder.estimateBulkSizeUsingCompression;
        this.maxLocalCompressionsForEstimation = builder.maxLocalCompressionsForEstimation;
        this.flushTimeout = builder.flushTimeout;
        this.routingField = builder.routingField;
        this.routing = builder.routing;
        String documentIdField = builder.documentIdField;
        String documentId = builder.documentId;
        if (this.indexType.equals((Object)IndexType.TRACE_ANALYTICS_RAW) || this.indexType.equals((Object)IndexType.TRACE_ANALYTICS_RAW_PLAIN)) {
            documentId = "${traceId}/${spanId}";
        } else if (this.indexType.equals((Object)IndexType.TRACE_ANALYTICS_SERVICE_MAP)) {
            documentId = "${hashId}";
        }
        this.documentIdField = documentIdField;
        this.documentId = documentId;
        this.ismPolicyFile = builder.ismPolicyFile;
        this.action = builder.action;
        this.actions = builder.actions;
        this.documentRootKey = builder.documentRootKey;
        this.queryWhen = builder.queryWhen;
        this.queryTerm = builder.queryTerm;
        this.queryActionOnFound = builder.actionOnFound;
        this.queryDuration = builder.queryDuration;
        this.queryAsyncDocumentLimit = builder.queryAsyncLimit;
    }

    private void determineIndexType(Builder builder) {
        if (builder.indexType != null) {
            Optional<IndexType> mappedIndexType = IndexType.getByValue(builder.indexType);
            this.indexType = mappedIndexType.orElseThrow(() -> new IllegalArgumentException("Value of the parameter, index_type, must be from the list: " + IndexType.getIndexTypeValues()));
        } else {
            this.indexType = builder.serverless ? IndexType.MANAGEMENT_DISABLED : IndexType.CUSTOM;
        }
    }

    private void determineTemplateType(Builder builder) {
        this.templateType = builder.serverless ? TemplateType.INDEX_TEMPLATE : (DistributionVersion.ES6.equals((Object)builder.distributionVersion) ? TemplateType.V1 : (builder.templateType != null ? builder.templateType : TemplateType.V1));
    }

    public static IndexConfiguration readIndexConfig(OpenSearchSinkConfig openSearchSinkConfig) {
        return IndexConfiguration.readIndexConfig(openSearchSinkConfig, null);
    }

    public static IndexConfiguration readIndexConfig(OpenSearchSinkConfig openSearchSinkConfig, ExpressionEvaluator expressionEvaluator) {
        String templateContent;
        String templateFile;
        String templateType;
        String indexType;
        Builder builder = new Builder();
        String indexAlias = openSearchSinkConfig.getIndexAlias();
        if (indexAlias != null) {
            builder = builder.withIndexAlias(indexAlias);
        }
        if ((indexType = openSearchSinkConfig.getIndexType()) != null) {
            builder = builder.withIndexType(indexType);
        }
        if ((templateType = openSearchSinkConfig.getTemplateType()) != null) {
            builder = builder.withTemplateType(templateType);
        }
        if ((templateFile = openSearchSinkConfig.getTemplateFile()) != null) {
            builder = builder.withTemplateFile(templateFile);
        }
        if ((templateContent = openSearchSinkConfig.getTemplateContent()) != null) {
            builder = builder.withTemplateContent(templateContent);
        }
        if (templateContent != null && templateFile != null) {
            LOG.warn("Both template_content and template_file are configured. Only template_content will be used");
        }
        String documentIdField = openSearchSinkConfig.getDocumentIdField();
        String documentId = openSearchSinkConfig.getDocumentId();
        if (documentIdField != null) {
            LOG.warn("document_id_field is deprecated in favor of document_id, and support for document_id_field will be removed in a future major version release.");
            builder = builder.withDocumentIdField(documentIdField);
        } else if (documentId != null) {
            builder = builder.withDocumentId(documentId);
        }
        String routingField = openSearchSinkConfig.getRoutingField();
        String routing = openSearchSinkConfig.getRouting();
        if (routingField != null) {
            LOG.warn("routing_field is deprecated in favor of routing, and support for routing_field will be removed in a future major version release.");
            builder = builder.withRoutingField(routingField);
        } else if (routing != null) {
            builder = builder.withRouting(routing);
        }
        QueryForExistingDocumentConfiguration queryExistingConfiguration = openSearchSinkConfig.getQueryExistingConfiguration();
        if (queryExistingConfiguration != null) {
            if (!expressionEvaluator.isValidExpressionStatement(queryExistingConfiguration.getQueryWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("query_when %s is not a valid conditional expression statement", openSearchSinkConfig.getQueryExistingConfiguration()));
            }
            builder.withQueryWhen(queryExistingConfiguration.getQueryWhen());
            builder.withQueryTerm(queryExistingConfiguration.getQueryTerm());
            builder.withQueryDuration(queryExistingConfiguration.getQueryDuration());
            builder.withQueryOnIndexingFailure(queryExistingConfiguration.isQueryOnBulkErrors());
            builder.withQueryAsyncLimit(queryExistingConfiguration.getAsyncDocumentLimit());
            builder.withActionOnFound(ACTION_ON_FOUND_DROP);
        }
        builder = builder.withNumShards(openSearchSinkConfig.getNumShards()).withNumReplicas(openSearchSinkConfig.getNumReplicas()).withBulkSize(openSearchSinkConfig.getBulkSize()).withEstimateBulkSizeUsingCompression(openSearchSinkConfig.isEstimateBulkSizeUsingCompression()).withMaxLocalCompressionsForEstimation(openSearchSinkConfig.getMaxLocalCompressionsForEstimation()).withFlushTimeout(openSearchSinkConfig.getFlushTimeout()).withVersionType(openSearchSinkConfig.getVersionType()).withNormalizeIndex(openSearchSinkConfig.isNormalizeIndex()).withIsmPolicyFile(openSearchSinkConfig.getIsmPolicyFile()).withDocumentRootKey(openSearchSinkConfig.getDocumentRootKey()).withDistributionVersion(openSearchSinkConfig.getDistributionVersion());
        String versionExpression = openSearchSinkConfig.getVersionExpression();
        builder = builder.withVersionExpression(versionExpression);
        if (versionExpression != null && !expressionEvaluator.isValidFormatExpression(versionExpression).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("document_version \"%s\" is not a valid format expression.", versionExpression));
        }
        List<ActionConfiguration> actionList = openSearchSinkConfig.getActions();
        builder = actionList != null ? builder.withActions(actionList, expressionEvaluator) : builder.withAction(openSearchSinkConfig.getAction(), expressionEvaluator);
        AwsAuthenticationConfiguration awsAuthenticationConfiguration = openSearchSinkConfig.getAwsAuthenticationOptions();
        builder = awsAuthenticationConfiguration != null ? builder.withServerless(awsAuthenticationConfiguration.isServerlessCollection()) : builder.withServerless(false);
        if (builder.templateFile != null && builder.templateFile.startsWith(S3_PREFIX) || builder.ismPolicyFile.isPresent() && builder.ismPolicyFile.get().startsWith(S3_PREFIX)) {
            builder.withS3AwsRegion(awsAuthenticationConfiguration.getAwsRegion().toString());
            builder.withS3AWSStsRoleArn(awsAuthenticationConfiguration.getAwsStsRoleArn());
            builder.withS3AWSStsExternalId(awsAuthenticationConfiguration.getAwsStsExternalId());
            S3ClientProvider clientProvider = new S3ClientProvider(builder.s3AwsRegion, builder.s3AwsStsRoleArn, builder.s3AwsStsExternalId);
            builder.withS3Client(clientProvider.buildS3Client());
        }
        return builder.build();
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public String getIndexAlias() {
        return this.indexAlias;
    }

    public Map<String, Object> getIndexTemplate() {
        return this.indexTemplate;
    }

    public String getDocumentIdField() {
        return this.documentIdField;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public String getRouting() {
        return this.routing;
    }

    public long getBulkSize() {
        return this.bulkSize;
    }

    public boolean isEstimateBulkSizeUsingCompression() {
        return this.estimateBulkSizeUsingCompression;
    }

    public int getMaxLocalCompressionsForEstimation() {
        return this.maxLocalCompressionsForEstimation;
    }

    public long getFlushTimeout() {
        return this.flushTimeout;
    }

    public Optional<String> getIsmPolicyFile() {
        return this.ismPolicyFile;
    }

    public String getAction() {
        return this.action;
    }

    public List<ActionConfiguration> getActions() {
        return this.actions;
    }

    public String getS3AwsRegion() {
        return this.s3AwsRegion;
    }

    public String getS3AwsStsRoleArn() {
        return this.s3AwsStsRoleArn;
    }

    public String getS3AwsStsExternalId() {
        return this.s3AwsExternalId;
    }

    public boolean getServerless() {
        return this.serverless;
    }

    public DistributionVersion getDistributionVersion() {
        return this.distributionVersion;
    }

    public String getDocumentRootKey() {
        return this.documentRootKey;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public String getVersionExpression() {
        return this.versionExpression;
    }

    public boolean isNormalizeIndex() {
        return this.normalizeIndex;
    }

    public String getQueryWhen() {
        return this.queryWhen;
    }

    public Duration getQueryDuration() {
        return this.queryDuration;
    }

    public String getQueryTerm() {
        return this.queryTerm;
    }

    public boolean getQueryOnBulkFailures() {
        return this.queryOnBulkFailures;
    }

    public Integer getQueryAsyncDocumentLimit() {
        return this.queryAsyncDocumentLimit;
    }

    private Map<String, Object> readIndexTemplate(String templateFile, IndexType indexType, TemplateType templateType) {
        try {
            URL templateURL = null;
            InputStream s3TemplateFile = null;
            if (indexType.equals((Object)IndexType.TRACE_ANALYTICS_RAW)) {
                templateURL = this.loadExistingTemplate(templateType, "otel-v1-apm-span-index-template.json");
            } else if (indexType.equals((Object)IndexType.TRACE_ANALYTICS_RAW_PLAIN)) {
                templateURL = this.loadExistingTemplate(templateType, "otel-v1-apm-span-index-standard-template.json");
            } else if (indexType.equals((Object)IndexType.TRACE_ANALYTICS_SERVICE_MAP)) {
                templateURL = this.loadExistingTemplate(templateType, "otel-v1-apm-service-map-index-template.json");
            } else if (indexType.equals((Object)IndexType.OTEL_APM_SERVICE_MAP)) {
                templateURL = this.loadExistingTemplate(templateType, "otel-v2-apm-service-map-index-template.json");
            } else if (indexType.equals((Object)IndexType.LOG_ANALYTICS)) {
                templateURL = this.loadExistingTemplate(templateType, "logs-otel-v1-index-template.json");
            } else if (indexType.equals((Object)IndexType.LOG_ANALYTICS_PLAIN)) {
                templateURL = this.loadExistingTemplate(templateType, "logs-otel-v1-index-standard-template.json");
            } else if (indexType.equals((Object)IndexType.METRIC_ANALYTICS)) {
                templateURL = this.loadExistingTemplate(templateType, "metrics-otel-v1-index-template.json");
            } else if (indexType.equals((Object)IndexType.METRIC_ANALYTICS_PLAIN)) {
                templateURL = this.loadExistingTemplate(templateType, "metrics-otel-v1-index-standard-template.json");
            } else if (templateFile != null) {
                if (templateFile.toLowerCase().startsWith(S3_PREFIX)) {
                    S3FileReader s3FileReader = new S3FileReader(this.s3Client);
                    s3TemplateFile = s3FileReader.readFile(templateFile);
                } else {
                    templateURL = new File(templateFile).toURI().toURL();
                }
            }
            if (templateURL != null) {
                return (Map)new ObjectMapper().readValue(templateURL, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            if (s3TemplateFile != null) {
                return (Map)new ObjectMapper().readValue(s3TemplateFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            return new HashMap<String, Object>();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Index template is not valid.", ex);
        }
    }

    private Map<String, Object> readTemplateContent(String templateContent) {
        try {
            return (Map)OBJECT_MAPPER.readValue(templateContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException ex) {
            throw new InvalidPluginConfigurationException(String.format("template_content is invalid: %s", ex.getMessage()));
        }
    }

    private URL loadExistingTemplate(TemplateType templateType, String predefinedTemplateName) {
        String resourcePath = templateType == TemplateType.V1 ? predefinedTemplateName : templateType.getTypeName() + "/" + predefinedTemplateName;
        return this.getClass().getClassLoader().getResource(resourcePath);
    }

    public static class Builder {
        private String indexAlias;
        private String indexType;
        private TemplateType templateType;
        private String templateFile;
        private String templateContent;
        private int numShards;
        private int numReplicas;
        private String routingField;
        private String routing;
        private String pipeline;
        private String documentIdField;
        private String documentId;
        private long bulkSize = 5L;
        private boolean estimateBulkSizeUsingCompression = false;
        private int maxLocalCompressionsForEstimation = 2;
        private long flushTimeout = 60000L;
        private Optional<String> ismPolicyFile;
        private String action;
        private List<ActionConfiguration> actions;
        private String s3AwsRegion;
        private String s3AwsStsRoleArn;
        private String s3AwsStsExternalId;
        private S3Client s3Client;
        private boolean serverless;
        private DistributionVersion distributionVersion;
        private String documentRootKey;
        private VersionType versionType;
        private String versionExpression;
        private boolean normalizeIndex;
        private String queryTerm;
        private String queryWhen;
        private String actionOnFound;
        private Duration queryDuration;
        private boolean queryOnIndexingFailure;
        private Integer queryAsyncLimit;

        public Builder withIndexAlias(String indexAlias) {
            Preconditions.checkArgument((indexAlias != null ? 1 : 0) != 0, (Object)"indexAlias cannot be null.");
            Preconditions.checkArgument((!indexAlias.isEmpty() ? 1 : 0) != 0, (Object)"indexAlias cannot be empty");
            this.indexAlias = indexAlias;
            return this;
        }

        public Builder withIndexType(String indexType) {
            Preconditions.checkArgument((indexType != null ? 1 : 0) != 0, (Object)"indexType cannot be null.");
            Preconditions.checkArgument((!indexType.isEmpty() ? 1 : 0) != 0, (Object)"indexType cannot be empty");
            this.indexType = indexType;
            return this;
        }

        public Builder withTemplateType(String templateType) {
            Preconditions.checkArgument((templateType != null ? 1 : 0) != 0, (Object)"templateType cannot be null.");
            Preconditions.checkArgument((!templateType.isEmpty() ? 1 : 0) != 0, (Object)"templateType cannot be empty");
            this.templateType = TemplateType.fromTypeName(templateType);
            return this;
        }

        public Builder withTemplateFile(String templateFile) {
            Preconditions.checkArgument((templateFile != null ? 1 : 0) != 0, (Object)"templateFile cannot be null.");
            this.templateFile = templateFile;
            return this;
        }

        public Builder withTemplateContent(String templateContent) {
            Preconditions.checkArgument((templateContent != null ? 1 : 0) != 0, (Object)"templateContent cannot be null.");
            this.templateContent = templateContent;
            return this;
        }

        public Builder withDocumentIdField(String documentIdField) {
            Preconditions.checkNotNull((Object)documentIdField, (Object)"document_id_field cannot be null");
            this.documentIdField = documentIdField;
            return this;
        }

        public Builder withDocumentId(String documentId) {
            Preconditions.checkNotNull((Object)documentId, (Object)"document_id cannot be null");
            this.documentId = documentId;
            return this;
        }

        public Builder withRoutingField(String routingField) {
            this.routingField = routingField;
            return this;
        }

        public Builder withRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withBulkSize(long bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder withEstimateBulkSizeUsingCompression(boolean estimateBulkSizeUsingCompression) {
            this.estimateBulkSizeUsingCompression = estimateBulkSizeUsingCompression;
            return this;
        }

        public Builder withMaxLocalCompressionsForEstimation(int maxLocalCompressionsForEstimation) {
            this.maxLocalCompressionsForEstimation = maxLocalCompressionsForEstimation;
            return this;
        }

        public Builder withFlushTimeout(long flushTimeout) {
            this.flushTimeout = flushTimeout;
            return this;
        }

        public Builder withNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        public Builder withNumReplicas(int numReplicas) {
            this.numReplicas = numReplicas;
            return this;
        }

        public Builder withIsmPolicyFile(String ismPolicyFile) {
            this.ismPolicyFile = Optional.ofNullable(ismPolicyFile);
            return this;
        }

        public Builder withAction(String action, ExpressionEvaluator expressionEvaluator) {
            Preconditions.checkArgument((EnumUtils.isValidEnumIgnoreCase(OpenSearchBulkActions.class, (String)action) || action.contains("${") && expressionEvaluator.isValidFormatExpression(action) != false ? 1 : 0) != 0, (Object)("action \"" + action + "\" is invalid. action must be one of the following: " + String.valueOf(Arrays.stream(OpenSearchBulkActions.values()).collect(Collectors.toList()))));
            this.action = action;
            return this;
        }

        public Builder withActions(List<ActionConfiguration> actions, ExpressionEvaluator expressionEvaluator) {
            for (ActionConfiguration actionConfig : actions) {
                String action = actionConfig.getType();
                if (action == null) continue;
                Preconditions.checkArgument((EnumUtils.isValidEnumIgnoreCase(OpenSearchBulkActions.class, (String)action) || action.contains("${") && expressionEvaluator.isValidFormatExpression(action) != false ? 1 : 0) != 0, (Object)("action \"" + action + "\". action must be one of the following: " + String.valueOf(Arrays.stream(OpenSearchBulkActions.values()).collect(Collectors.toList()))));
            }
            this.actions = actions;
            return this;
        }

        public Builder withS3AwsRegion(String s3AwsRegion) {
            Preconditions.checkNotNull((Object)s3AwsRegion, (Object)"s3AwsRegion cannot be null");
            this.s3AwsRegion = s3AwsRegion;
            return this;
        }

        public Builder withS3AWSStsRoleArn(String s3AwsStsRoleArn) {
            Preconditions.checkArgument((s3AwsStsRoleArn == null || s3AwsStsRoleArn.length() <= 2048 ? 1 : 0) != 0, (Object)"s3AwsStsRoleArn length cannot exceed 2048");
            if (s3AwsStsRoleArn != null) {
                try {
                    Arn.fromString((String)s3AwsStsRoleArn);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid ARN format for s3AwsStsRoleArn");
                }
            }
            this.s3AwsStsRoleArn = s3AwsStsRoleArn;
            return this;
        }

        public Builder withS3AWSStsExternalId(String s3AwsStsExternalId) {
            Preconditions.checkArgument((s3AwsStsExternalId == null || s3AwsStsExternalId.length() <= 1224 ? 1 : 0) != 0, (Object)"s3AwsStsExternalId length cannot exceed 1224");
            this.s3AwsStsExternalId = s3AwsStsExternalId;
            return this;
        }

        public Builder withS3Client(S3Client s3Client) {
            Preconditions.checkArgument((s3Client != null ? 1 : 0) != 0);
            this.s3Client = s3Client;
            return this;
        }

        public Builder withServerless(boolean serverless) {
            this.serverless = serverless;
            return this;
        }

        public Builder withDistributionVersion(String distributionVersion) {
            this.distributionVersion = DistributionVersion.fromTypeName(distributionVersion);
            return this;
        }

        public Builder withDocumentRootKey(String documentRootKey) {
            if (documentRootKey != null) {
                Preconditions.checkArgument((!documentRootKey.isEmpty() ? 1 : 0) != 0, (Object)"documentRootKey cannot be empty string");
            }
            this.documentRootKey = documentRootKey;
            return this;
        }

        public Builder withVersionType(String versionType) {
            if (versionType != null) {
                try {
                    this.versionType = this.getVersionType(versionType);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidPluginConfigurationException(String.format("version_type %s is invalid. version_type must be one of: %s", versionType, Arrays.stream(VersionType.values()).collect(Collectors.toList())));
                }
            }
            return this;
        }

        public Builder withNormalizeIndex(boolean normalizeIndex) {
            this.normalizeIndex = normalizeIndex;
            return this;
        }

        private VersionType getVersionType(String versionType) {
            switch (versionType.toLowerCase()) {
                case "internal": {
                    return VersionType.Internal;
                }
                case "external": {
                    return VersionType.External;
                }
                case "external_gte": {
                    return VersionType.ExternalGte;
                }
            }
            throw new IllegalArgumentException();
        }

        public Builder withVersionExpression(String versionExpression) {
            if (versionExpression != null && !versionExpression.contains("${")) {
                throw new InvalidPluginConfigurationException(String.format("document_version %s is invalid. It must be in the format of \"${/key}\" or \"${expression}\"", versionExpression));
            }
            this.versionExpression = versionExpression;
            return this;
        }

        public Builder withQueryTerm(String queryTerm) {
            this.queryTerm = queryTerm;
            return this;
        }

        public Builder withQueryWhen(String queryWhen) {
            this.queryWhen = queryWhen;
            return this;
        }

        public Builder withQueryDuration(Duration queryDuration) {
            this.queryDuration = queryDuration;
            return this;
        }

        public Builder withActionOnFound(String actionOnFound) {
            if (!Objects.equals(actionOnFound, IndexConfiguration.ACTION_ON_FOUND_DROP)) {
                throw new InvalidPluginConfigurationException("Only \"drop\" is supported for query_for_existing_document.action_on_found");
            }
            this.actionOnFound = actionOnFound;
            return this;
        }

        public Builder withQueryOnIndexingFailure(boolean queryOnIndexingFailure) {
            this.queryOnIndexingFailure = queryOnIndexingFailure;
            return this;
        }

        public Builder withQueryAsyncLimit(Integer queryAsyncLimit) {
            this.queryAsyncLimit = queryAsyncLimit;
            return this;
        }

        public IndexConfiguration build() {
            return new IndexConfiguration(this);
        }
    }
}

