/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.dlq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.ErrorCauseStringCreator;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedBulkOperation;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedDlqData;

public class FailedBulkOperationConverter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String pluginName;
    private final String pipelineName;

    public FailedBulkOperationConverter(String pipelineName, String pluginName) {
        Objects.requireNonNull(pipelineName);
        Objects.requireNonNull(pluginName);
        this.pluginName = pluginName;
        this.pipelineName = pipelineName;
    }

    public DlqObject convertToDlqObject(FailedBulkOperation failedBulkOperation) {
        BulkOperationWrapper bulkOperationWithHandle = failedBulkOperation.getBulkOperation();
        BulkResponseItem bulkResponseItem = failedBulkOperation.getBulkResponseItem();
        Object document = this.convertDocumentToGenericMap(bulkOperationWithHandle);
        FailedDlqData.Builder failedDlqDataBuilder = FailedDlqData.builder().withIndex(bulkOperationWithHandle.getIndex()).withIndexId(bulkOperationWithHandle.getId()).withDocument(document);
        if (bulkResponseItem != null) {
            String message = ErrorCauseStringCreator.toSingleLineDisplayString(bulkResponseItem.error());
            failedDlqDataBuilder.withStatus(bulkResponseItem.status()).withMessage(message);
        } else {
            failedDlqDataBuilder.withMessage(failedBulkOperation.getFailure().getMessage());
        }
        DlqObject.Builder builder = DlqObject.builder().withFailedData((Object)failedDlqDataBuilder.build()).withPluginName(this.pluginName).withPipelineName(this.pipelineName).withPluginId(this.pluginName);
        if (bulkOperationWithHandle.getEvent() != null) {
            builder.withEvent(bulkOperationWithHandle.getEvent());
        } else {
            builder.withEventHandle(bulkOperationWithHandle.getEventHandle());
        }
        return builder.build();
    }

    private Object convertDocumentToGenericMap(BulkOperationWrapper bulkOperation) {
        SerializedJson document = (SerializedJson)bulkOperation.getDocument();
        if (document == null) {
            return ImmutableMap.of();
        }
        byte[] documentBytes = document.getSerializedJson();
        String jsonString = new String(documentBytes, StandardCharsets.UTF_8);
        try {
            return OBJECT_MAPPER.readValue(jsonString, Object.class);
        }
        catch (IOException e) {
            return ImmutableMap.of();
        }
    }
}

