/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.AccumulatingBulkRequest;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJsonImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClientAccumulatingCompressedBulkRequest
implements AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClientAccumulatingCompressedBulkRequest.class);
    private final List<BulkOperationWrapper> bulkOperations;
    private long sampleSize;
    private final long targetBulkSize;
    private final int maxLocalCompressionsForEstimation;
    private BulkRequest.Builder bulkRequestBuilder;
    private long currentBulkSize = 0L;
    private double sampledOperationSize = 0.0;
    private int operationCount = 0;
    private int timesSampled = 0;
    private BulkRequest builtRequest;

    public JavaClientAccumulatingCompressedBulkRequest(BulkRequest.Builder bulkRequestBuilder, long targetBulkSize, int maxLocalCompressionsForEstimation) {
        this.bulkRequestBuilder = bulkRequestBuilder;
        this.bulkOperations = new ArrayList<BulkOperationWrapper>();
        this.targetBulkSize = targetBulkSize;
        this.maxLocalCompressionsForEstimation = maxLocalCompressionsForEstimation;
        this.sampleSize = 10L;
    }

    @VisibleForTesting
    JavaClientAccumulatingCompressedBulkRequest(BulkRequest.Builder bulkRequestBuilder, long targetBulkSize, int maxLocalCompressionsForEstimation, int sampleSize) {
        this.bulkRequestBuilder = bulkRequestBuilder;
        this.bulkOperations = new ArrayList<BulkOperationWrapper>();
        this.targetBulkSize = targetBulkSize;
        this.maxLocalCompressionsForEstimation = maxLocalCompressionsForEstimation;
        this.sampleSize = sampleSize;
    }

    @Override
    public long estimateSizeInBytesWithDocument(BulkOperationWrapper documentOrOperation) {
        return this.currentBulkSize + (long)this.sampledOperationSize;
    }

    @Override
    public void addOperation(BulkOperationWrapper bulkOperation) {
        this.bulkRequestBuilder = this.bulkRequestBuilder.operations(bulkOperation.getBulkOperation(), new BulkOperation[0]);
        ++this.operationCount;
        this.bulkOperations.add(bulkOperation);
        if (this.timesSampled < this.maxLocalCompressionsForEstimation && (long)this.bulkOperations.size() == this.sampleSize) {
            this.currentBulkSize = this.estimateBulkSize();
            this.sampledOperationSize = (double)this.currentBulkSize / (double)this.bulkOperations.size();
            this.updateTargetSampleSize();
            ++this.timesSampled;
        } else {
            this.currentBulkSize = (long)((double)this.currentBulkSize + this.sampledOperationSize);
        }
    }

    @Override
    public BulkOperationWrapper getOperationAt(int index) {
        return this.bulkOperations.get(index);
    }

    @Override
    public long getEstimatedSizeInBytes() {
        if (this.currentBulkSize == 0L) {
            this.currentBulkSize = this.estimateBulkSize();
        }
        return this.currentBulkSize;
    }

    @Override
    public int getOperationsCount() {
        return this.operationCount;
    }

    @Override
    public List<BulkOperationWrapper> getOperations() {
        return Collections.unmodifiableList(this.bulkOperations);
    }

    @Override
    public BulkRequest getRequest() {
        if (this.builtRequest == null) {
            this.builtRequest = this.bulkRequestBuilder.build();
        }
        return this.builtRequest;
    }

    private long estimateBulkSize() {
        List documents = this.bulkOperations.stream().map(this::mapBulkOperationToDocument).collect(Collectors.toList());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
            ObjectOutputStream objectOut = new ObjectOutputStream(gzipOut);
            objectOut.writeObject(documents);
            objectOut.close();
            return baos.toByteArray().length;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception measuring compressed bulk request size.", e);
        }
    }

    private Object mapBulkOperationToDocument(BulkOperationWrapper bulkOperation) {
        Object anyDocument = bulkOperation.getDocument();
        if (anyDocument == null) {
            return new SerializedJsonImpl(null);
        }
        if (!(anyDocument instanceof Serializable)) {
            throw new IllegalArgumentException("Only classes implementing Serializable are permitted for accumulating bulk requests. " + String.valueOf(bulkOperation));
        }
        return anyDocument;
    }

    private void updateTargetSampleSize() {
        long remainingBytes = this.targetBulkSize - this.currentBulkSize;
        double remainingBytesAsPercentage = (double)remainingBytes / (double)this.targetBulkSize * 100.0;
        if (remainingBytesAsPercentage < 10.0) {
            LOG.debug("Found remaining percentage of {}, current size {}, target size {}. Skipping further estimations", new Object[]{remainingBytesAsPercentage, this.currentBulkSize, this.targetBulkSize});
            return;
        }
        double estimatedRemainingOperationsUntilFull = (double)remainingBytes / this.sampledOperationSize;
        if (estimatedRemainingOperationsUntilFull < 100.0) {
            LOG.debug("Found estimated remaining operations of {}. Skipping further estimations", (Object)estimatedRemainingOperationsUntilFull);
            return;
        }
        double operationsUntilNextSample = estimatedRemainingOperationsUntilFull / 2.0;
        LOG.debug("{} bytes remaining to {}. Average size so far {}, checking again in {} ops", new Object[]{this.targetBulkSize - this.currentBulkSize, this.targetBulkSize, this.sampledOperationSize, operationsUntilNextSample});
        this.sampleSize = (long)((double)this.sampleSize + operationsUntilNextSample);
    }
}

