/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.common.sink.SinkBufferWriter;
import org.opensearch.dataprepper.common.sink.SinkFlushContext;
import org.opensearch.dataprepper.common.sink.SinkFlushableBuffer;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferEntry;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferWriterEntry;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkFlushableBuffer;
import software.amazon.awssdk.utils.Pair;

public class PrometheusSinkBufferWriter
implements SinkBufferWriter {
    private static final int MAX_EVENTS_PER_SERIES = 1000;
    private final Map<String, PrometheusSinkBufferWriterEntry> buffer = new HashMap<String, PrometheusSinkBufferWriterEntry>();
    private final SinkMetrics sinkMetrics;
    private final long outOfOrderWindowMillis;
    private final long maxEvents;
    private final long maxRequestSize;

    public PrometheusSinkBufferWriter(PrometheusSinkConfiguration sinkConfig, SinkMetrics sinkMetrics) {
        this.sinkMetrics = sinkMetrics;
        this.outOfOrderWindowMillis = sinkConfig.getOutOfOrderTimeWindow().toMillis();
        this.maxEvents = sinkConfig.getThresholdConfig().getMaxEvents();
        this.maxRequestSize = sinkConfig.getThresholdConfig().getMaxRequestSizeBytes();
    }

    private String getSeriesKey(PrometheusSinkBufferEntry bufferEntry) {
        return bufferEntry.getTimeSeries().getMetricKey();
    }

    public boolean isMaxEventsLimitReached(long maxEvents) {
        return this.buffer.values().stream().mapToLong(PrometheusSinkBufferWriterEntry::getNumberOfEntriesReadyToFlush).sum() >= maxEvents;
    }

    public boolean willExceedMaxRequestSizeBytes(SinkBufferEntry sinkBufferEntry, long maxRequestSize) {
        return this.buffer.values().stream().mapToLong(PrometheusSinkBufferWriterEntry::getSizeOfEntriesReadyToFlush).sum() >= maxRequestSize;
    }

    public boolean writeToBuffer(SinkBufferEntry bufferEntry) {
        PrometheusSinkBufferEntry entry = (PrometheusSinkBufferEntry)bufferEntry;
        if (entry.getTimeSeries() == null || (long)entry.getTimeSeries().getSize() >= this.maxRequestSize) {
            return false;
        }
        String seriesKey = this.getSeriesKey(entry);
        boolean result = this.buffer.computeIfAbsent(seriesKey, k -> new PrometheusSinkBufferWriterEntry(this.outOfOrderWindowMillis, 1000)).add(entry);
        if (!result) {
            this.sinkMetrics.incrementEventsDroppedCounter(1);
        }
        return result;
    }

    @VisibleForTesting
    long getBufferSize() {
        return this.buffer.size();
    }

    public SinkFlushableBuffer getBuffer(SinkFlushContext sinkFlushContext) {
        ArrayList<SinkBufferEntry> bufferList = new ArrayList<SinkBufferEntry>();
        long curMaxEvents = this.maxEvents;
        long curMaxSize = this.maxRequestSize;
        long reqSize = 0L;
        for (Map.Entry<String, PrometheusSinkBufferWriterEntry> entry2 : this.buffer.entrySet()) {
            if (curMaxEvents == 0L || curMaxSize == 0L) break;
            Pair<List<PrometheusSinkBufferEntry>, Long> result = entry2.getValue().getEntriesReadyToFlush(curMaxEvents, curMaxSize);
            if (((List)result.left()).isEmpty()) continue;
            curMaxEvents -= (long)((List)result.left()).size();
            curMaxSize -= ((Long)result.right()).longValue();
            reqSize += ((Long)result.right()).longValue();
            bufferList.addAll((Collection)result.left());
        }
        if (bufferList.isEmpty()) {
            return null;
        }
        this.sinkMetrics.recordRequestSize((double)reqSize);
        this.buffer.entrySet().removeIf(entry -> ((PrometheusSinkBufferWriterEntry)entry.getValue()).getSize() == 0L);
        return new PrometheusSinkFlushableBuffer(bufferList, this.sinkMetrics, sinkFlushContext);
    }
}

