/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.configuration;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.kinesis.common.InitialPositionInStream;

public enum InitialPositionInStreamConfig {
    LATEST("latest", InitialPositionInStream.LATEST),
    EARLIEST("earliest", InitialPositionInStream.TRIM_HORIZON),
    AT_TIMESTAMP("at_timestamp", InitialPositionInStream.AT_TIMESTAMP);

    private final String position;
    private final InitialPositionInStream positionInStream;
    private static final Map<String, InitialPositionInStreamConfig> POSITIONS_MAP;

    private InitialPositionInStreamConfig(String position, InitialPositionInStream positionInStream) {
        this.position = position;
        this.positionInStream = positionInStream;
    }

    public static InitialPositionInStreamConfig fromPositionValue(String position) {
        return POSITIONS_MAP.get(position.toLowerCase());
    }

    public String toString() {
        return this.position;
    }

    public String getPosition() {
        return this.position;
    }

    public InitialPositionInStream getPositionInStream() {
        return this.positionInStream;
    }

    static {
        POSITIONS_MAP = Arrays.stream(InitialPositionInStreamConfig.values()).collect(Collectors.toMap(value -> value.position, value -> value));
    }
}

