/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;

public class OtlpSinkMetrics {
    private final PluginMetrics pluginMetrics;
    private final Timer httpLatency;
    private final DistributionSummary payloadSize;
    private final DistributionSummary payloadGzipSize;

    public OtlpSinkMetrics(@Nonnull PluginMetrics pluginMetrics, @Nonnull PluginSetting pluginSetting) {
        this.pluginMetrics = pluginMetrics;
        this.httpLatency = pluginMetrics.timer("httpLatency");
        this.payloadSize = pluginMetrics.summary("payloadSize");
        this.payloadGzipSize = pluginMetrics.summary("payloadGzipSize");
    }

    public void incrementRecordsOut(long count) {
        this.pluginMetrics.counter("recordsOut").increment((double)count);
    }

    public void incrementErrorsCount() {
        this.pluginMetrics.counter("errorsCount").increment(1.0);
    }

    public void incrementPayloadSize(long bytes) {
        this.payloadSize.record((double)bytes);
    }

    public void incrementPayloadGzipSize(long bytes) {
        this.payloadGzipSize.record((double)bytes);
    }

    public void recordHttpLatency(long durationMillis) {
        this.httpLatency.record(Duration.ofMillis(durationMillis));
    }

    public void registerQueueGauges(BlockingQueue<?> queue) {
        this.pluginMetrics.gauge("queueSize", queue, Collection::size);
        this.pluginMetrics.gauge("queueCapacity", queue, q -> q.remainingCapacity() + q.size());
    }

    public void incrementRejectedSpansCount(long count) {
        this.pluginMetrics.counter("rejectedSpansCount").increment((double)count);
    }

    public void incrementFailedSpansCount(long count) {
        this.pluginMetrics.counter("failedSpansCount").increment((double)count);
    }

    public void recordResponseCode(int statusCode) {
        String codeCategory = statusCode / 100 + "xx";
        this.pluginMetrics.counter("http" + codeCategory + "Responses").increment();
    }
}

