/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.DataQueryProgressState;

public class DataQueryPartition
extends EnhancedSourcePartition<DataQueryProgressState> {
    public static final String PARTITION_TYPE = "DATA_QUERY";
    private final String collection;
    private final String query;
    private final DataQueryProgressState state;

    public DataQueryPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        this.collection = this.getCollection(sourcePartitionStoreItem.getSourcePartitionKey());
        this.query = sourcePartitionStoreItem.getSourcePartitionKey();
        this.state = (DataQueryProgressState)this.convertStringToPartitionProgressState(DataQueryProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public DataQueryPartition(String query, DataQueryProgressState state) {
        this.collection = this.getCollection(query);
        this.query = query;
        this.state = state;
    }

    private String getCollection(String partitionKey) {
        String[] keySplits = partitionKey.split("\\|");
        return keySplits[0];
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.query;
    }

    public Optional<DataQueryProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getCollection() {
        return this.collection;
    }

    public String getQuery() {
        return this.query;
    }
}

