/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.MetadataKeyValuePair;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveSchemaVersionMetadataRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, RemoveSchemaVersionMetadataRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(RemoveSchemaVersionMetadataRequest.getter(RemoveSchemaVersionMetadataRequest::schemaId)).setter(RemoveSchemaVersionMetadataRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<SchemaVersionNumber> SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaVersionNumber").getter(RemoveSchemaVersionMetadataRequest.getter(RemoveSchemaVersionMetadataRequest::schemaVersionNumber)).setter(RemoveSchemaVersionMetadataRequest.setter(Builder::schemaVersionNumber)).constructor(SchemaVersionNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(RemoveSchemaVersionMetadataRequest.getter(RemoveSchemaVersionMetadataRequest::schemaVersionId)).setter(RemoveSchemaVersionMetadataRequest.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<MetadataKeyValuePair> METADATA_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataKeyValue").getter(RemoveSchemaVersionMetadataRequest.getter(RemoveSchemaVersionMetadataRequest::metadataKeyValue)).setter(RemoveSchemaVersionMetadataRequest.setter(Builder::metadataKeyValue)).constructor(MetadataKeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataKeyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD, SCHEMA_VERSION_ID_FIELD, METADATA_KEY_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveSchemaVersionMetadataRequest.memberNameToFieldInitializer();
    private final SchemaId schemaId;
    private final SchemaVersionNumber schemaVersionNumber;
    private final String schemaVersionId;
    private final MetadataKeyValuePair metadataKeyValue;

    private RemoveSchemaVersionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
        this.schemaVersionId = builder.schemaVersionId;
        this.metadataKeyValue = builder.metadataKeyValue;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionNumber schemaVersionNumber() {
        return this.schemaVersionNumber;
    }

    public final String schemaVersionId() {
        return this.schemaVersionId;
    }

    public final MetadataKeyValuePair metadataKeyValue() {
        return this.metadataKeyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataKeyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveSchemaVersionMetadataRequest)) {
            return false;
        }
        RemoveSchemaVersionMetadataRequest other = (RemoveSchemaVersionMetadataRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaVersionNumber(), other.schemaVersionNumber()) && Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.metadataKeyValue(), other.metadataKeyValue());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveSchemaVersionMetadataRequest").add("SchemaId", (Object)this.schemaId()).add("SchemaVersionNumber", (Object)this.schemaVersionNumber()).add("SchemaVersionId", (Object)this.schemaVersionId()).add("MetadataKeyValue", (Object)this.metadataKeyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionNumber()));
            }
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "MetadataKeyValue": {
                return Optional.ofNullable(clazz.cast(this.metadataKeyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaVersionNumber", SCHEMA_VERSION_NUMBER_FIELD);
        map.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
        map.put("MetadataKeyValue", METADATA_KEY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveSchemaVersionMetadataRequest, T> g) {
        return obj -> g.apply((RemoveSchemaVersionMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private SchemaVersionNumber schemaVersionNumber;
        private String schemaVersionId;
        private MetadataKeyValuePair metadataKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveSchemaVersionMetadataRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.schemaVersionNumber(model.schemaVersionNumber);
            this.schemaVersionId(model.schemaVersionId);
            this.metadataKeyValue(model.metadataKeyValue);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final SchemaVersionNumber.Builder getSchemaVersionNumber() {
            return this.schemaVersionNumber != null ? this.schemaVersionNumber.toBuilder() : null;
        }

        public final void setSchemaVersionNumber(SchemaVersionNumber.BuilderImpl schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber != null ? schemaVersionNumber.build() : null;
        }

        @Override
        public final Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final MetadataKeyValuePair.Builder getMetadataKeyValue() {
            return this.metadataKeyValue != null ? this.metadataKeyValue.toBuilder() : null;
        }

        public final void setMetadataKeyValue(MetadataKeyValuePair.BuilderImpl metadataKeyValue) {
            this.metadataKeyValue = metadataKeyValue != null ? metadataKeyValue.build() : null;
        }

        @Override
        public final Builder metadataKeyValue(MetadataKeyValuePair metadataKeyValue) {
            this.metadataKeyValue = metadataKeyValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveSchemaVersionMetadataRequest build() {
            return new RemoveSchemaVersionMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveSchemaVersionMetadataRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder schemaVersionNumber(SchemaVersionNumber var1);

        default public Builder schemaVersionNumber(Consumer<SchemaVersionNumber.Builder> schemaVersionNumber) {
            return this.schemaVersionNumber((SchemaVersionNumber)((SchemaVersionNumber.Builder)SchemaVersionNumber.builder().applyMutation(schemaVersionNumber)).build());
        }

        public Builder schemaVersionId(String var1);

        public Builder metadataKeyValue(MetadataKeyValuePair var1);

        default public Builder metadataKeyValue(Consumer<MetadataKeyValuePair.Builder> metadataKeyValue) {
            return this.metadataKeyValue((MetadataKeyValuePair)((MetadataKeyValuePair.Builder)MetadataKeyValuePair.builder().applyMutation(metadataKeyValue)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

