/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.detect_format;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The detect format processor detect format of the data in a specific field")
public class DetectFormatProcessorConfig {
    public static final String DEFAULT_KV_DELIMITER = "=";
    public static final List<String> DEFAULT_KV_SEPARATOR_LIST = List.of(" ", ",", "&");
    @JsonPropertyDescription(value="The source key on which to perform the operation.")
    @JsonProperty(value="source")
    @NotEmpty
    @NotNull
    private String source;
    @JsonPropertyDescription(value="Target key name where the detected format result is stored")
    @JsonProperty(value="target_key")
    private String targetKey;
    @JsonPropertyDescription(value="Target metadata key name where the detected format result is stored")
    @JsonProperty(value="target_metadata_key")
    private String targetMetadataKey;
    @JsonPropertyDescription(value="Key Value Delimiter")
    @JsonProperty(value="key_value_delimiter")
    private String kvDelimiter = "=";
    @JsonPropertyDescription(value="Key Value Separator List")
    @JsonProperty(value="key_value_separator_list")
    private List<String> kvSeparatorList = DEFAULT_KV_SEPARATOR_LIST;
    @JsonProperty(value="detect_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/some_key == \"test\"</code>. If specified, the <code>detect_format</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs parsing on the Event if some_key is null or doesn't exist.")})
    private String detectWhen;

    @AssertTrue(message="At least one of target_key and target_metadata_key must be specified")
    @AssertTrue(message="At least one of target_key and target_metadata_key must be specified") boolean checkForTargetKeys() {
        return this.targetKey != null || this.targetMetadataKey != null;
    }

    public String getSource() {
        return this.source;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public String getTargetMetadataKey() {
        return this.targetMetadataKey;
    }

    public String getDetectWhen() {
        return this.detectWhen;
    }

    public String getKVDelimiter() {
        return this.kvDelimiter;
    }

    public List<String> getKVSeparatorList() {
        return this.kvSeparatorList;
    }
}

