/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.util;

import java.time.Duration;
import org.opensearch.dataprepper.plugins.ml_inference.processor.util.HttpClientExecutor;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;

public class SdkHttpClientExecutor
implements HttpClientExecutor {
    private final SdkHttpClient httpClient;
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(30L);
    private static final int DEFAULT_MAX_CONNECTIONS = 10;

    public SdkHttpClientExecutor() {
        this(DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT, 10);
    }

    public SdkHttpClientExecutor(Duration connectionTimeout, Duration readTimeout, int maxConnections) {
        AttributeMap attributeMap = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout).put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout).put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnections).build();
        this.httpClient = new DefaultSdkHttpClientBuilder().buildWithDefaults(attributeMap);
    }

    @Override
    public HttpExecuteResponse execute(HttpExecuteRequest executeRequest) throws Exception {
        return this.httpClient.prepareRequest(executeRequest).call();
    }
}

