/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.plugins.ml_inference.processor.configuration.ActionType;
import org.opensearch.dataprepper.plugins.ml_inference.processor.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.ml_inference.processor.configuration.ServiceName;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>ml</code> processor enables invocation of the ml-commons plugin in OpenSearch service within your pipeline in order to process events. It supports both synchronous and asynchronous invocations based on your use case.")
public class MLProcessorConfig {
    private static final int DEFAULT_MAX_BATCH_SIZE = 100;
    public static final Duration DEFAULT_RETRY_WINDOW = Duration.ofMinutes(10L);
    public static final int DEFAULT_RETRY_INTERVAL_SECONDS = 60;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonPropertyDescription(value="action type defines the way we want to invoke ml-commons in the predict API")
    @JsonProperty(value="action_type")
    private ActionType actionType = ActionType.BATCH_PREDICT;
    @JsonPropertyDescription(value="AI service hosting the remote model for ML Commons predictions")
    @JsonProperty(value="service_name")
    private ServiceName serviceName = ServiceName.SAGEMAKER;
    @JsonPropertyDescription(value="defines the OpenSearch host url to be invoked")
    @JsonProperty(value="host")
    private String hostUrl;
    @JsonPropertyDescription(value="defines the model id to be invoked in ml-commons")
    @JsonProperty(value="model_id")
    private String modelId;
    @JsonPropertyDescription(value="defines the S3 location to write the offline model responses to")
    @JsonProperty(value="output_path")
    private String outputPath;
    @JsonProperty(value="aws_sigv4")
    private boolean awsSigv4;
    @JsonProperty(value="input_key")
    @EventKeyConfiguration(value={EventKeyFactory.EventAction.GET})
    private EventKey inputKey;
    @JsonPropertyDescription(value="Defines a condition for event to use this processor.")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="The processor will only run on events where this condition evaluates to true.")})
    @JsonProperty(value="ml_when")
    private String whenCondition;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A <code>List</code> of <code>String</code>s that specifies the tags to be set in the event when ml_inference processor fails to create jobs or exception occurs. This tag may be used in conditional expressions in other parts of the configuration.")
    private List<String> tagsOnFailure = Collections.emptyList();
    @JsonProperty(value="max_batch_size")
    private int maxBatchSize = 100;
    @JsonPropertyDescription(value="The time duration for which the ml_inference processor retains events for retry attempts.Supports ISO_8601 notation Strings (\"PT20.345S\", \"PT15M\", etc.) as well as simple notation Strings for seconds (\"60s\") and milliseconds (\"1500ms\")")
    @JsonProperty(value="retry_time_window")
    private Duration retryTimeWindow = DEFAULT_RETRY_WINDOW;
    @JsonPropertyDescription(value="The retry interval for throttled records. Supports ISO_8601 duration notation (\"PT1M\", \"PT30S\") and simple notation (\"60s\", \"2m\"). Valid range: 3 seconds to 5 minutes. Default is 60 seconds.")
    @ExampleValues(value={@ExampleValues.Example(value="\"PT1M\"", description="ISO-8601 format for 1 minute"), @ExampleValues.Example(value="\"60s\"", description="Simple format for 60 seconds"), @ExampleValues.Example(value="\"2m\"", description="Simple format for 2 minutes")})
    @JsonProperty(value="retry_interval")
    @DurationMin(seconds=3L)
    @DurationMax(seconds=300L)
    private @DurationMin(seconds=3L) @DurationMax(seconds=300L) Duration retryInterval = Duration.ofSeconds(60L);
    @JsonProperty(value="dlq")
    private PluginModel dlq;

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public EventKey getInputKey() {
        return this.inputKey;
    }

    public String getWhenCondition() {
        return this.whenCondition;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    public PluginModel getDlq() {
        return this.dlq;
    }

    public Map<String, Object> getDlqPluginSetting() {
        return this.dlq != null ? this.dlq.getPluginSettings() : null;
    }

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public boolean isAwsSigv4() {
        return this.awsSigv4;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getRetryTimeWindow() {
        return this.retryTimeWindow;
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }
}

