/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Arrays;
import java.util.Comparator;
import javax.inject.Named;
import org.opensearch.dataprepper.plugin.ExtensionLoader;
import org.opensearch.dataprepper.plugin.PluginConfigurationObservableRegister;
import org.opensearch.dataprepper.plugin.PluginCreator;
import org.springframework.context.annotation.Bean;

@Named
public class PluginCreatorContext {
    @Bean(name={"extensionPluginCreator"})
    public PluginCreator observablePluginCreator() {
        return new PluginCreator();
    }

    @Bean(name={"pluginCreator"})
    public PluginCreator pluginCreator(PluginConfigurationObservableRegister pluginConfigurationObservableRegister) {
        return new PluginCreator(pluginConfigurationObservableRegister);
    }

    @Bean(name={"extensionsLoaderComparator"})
    public Comparator<ExtensionLoader.ExtensionPluginWithContext> extensionsLoaderComparator() {
        return (extensionOne, extensionTwo) -> {
            Class<?>[] extensionOneProvidedClasses = extensionOne.getProvidedClasses();
            Class<?>[] extensionTwoProvidedClasses = extensionTwo.getProvidedClasses();
            Class<?>[] extensionOneDependentClasses = extensionOne.getDependentClasses();
            Class<?>[] extensionTwoDependentClasses = extensionTwo.getDependentClasses();
            if (this.containsAnyExtensionDependencies(extensionOneProvidedClasses, extensionTwoDependentClasses)) {
                return -1;
            }
            if (this.containsAnyExtensionDependencies(extensionTwoProvidedClasses, extensionOneDependentClasses)) {
                return 1;
            }
            int configCompare = Boolean.compare(extensionTwo.isConfigured(), extensionOne.isConfigured());
            if (configCompare != 0) {
                return configCompare;
            }
            return 0;
        };
    }

    private boolean containsAnyExtensionDependencies(Class<?>[] provided, Class<?>[] dependencies) {
        return Arrays.stream(dependencies).anyMatch(dep -> Arrays.asList(provided).contains(dep));
    }
}

