/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.NoPluginFoundException;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugin.ApplicationContextToTypedSuppliers;
import org.opensearch.dataprepper.plugin.ComponentPluginArgumentsContext;
import org.opensearch.dataprepper.plugin.DefinedPlugin;
import org.opensearch.dataprepper.plugin.PluginBeanFactoryProvider;
import org.opensearch.dataprepper.plugin.PluginConfigurationConverter;
import org.opensearch.dataprepper.plugin.PluginConfigurationObservableFactory;
import org.opensearch.dataprepper.plugin.PluginCreator;
import org.opensearch.dataprepper.plugin.PluginProvider;
import org.opensearch.dataprepper.plugin.PluginProviderLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.DependsOn;

@Named
@DependsOn(value={"extensionsApplier"})
public class DefaultPluginFactory
implements PluginFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPluginFactory.class);
    private final Collection<PluginProvider> pluginProviders;
    private final PluginCreator pluginCreator;
    private final PluginConfigurationConverter pluginConfigurationConverter;
    private final PluginBeanFactoryProvider pluginBeanFactoryProvider;
    private final PluginConfigurationObservableFactory pluginConfigurationObservableFactory;
    private final ApplicationContextToTypedSuppliers applicationContextToTypedSuppliers;
    private final List<Consumer<DefinedPlugin<?>>> definedPluginConsumers;

    @Inject
    DefaultPluginFactory(PluginProviderLoader pluginProviderLoader, @Named(value="pluginCreator") PluginCreator pluginCreator, PluginConfigurationConverter pluginConfigurationConverter, PluginBeanFactoryProvider pluginBeanFactoryProvider, PluginConfigurationObservableFactory pluginConfigurationObservableFactory, ApplicationContextToTypedSuppliers applicationContextToTypedSuppliers, List<Consumer<DefinedPlugin<?>>> definedPluginConsumers) {
        this.applicationContextToTypedSuppliers = applicationContextToTypedSuppliers;
        this.definedPluginConsumers = definedPluginConsumers;
        Objects.requireNonNull(pluginProviderLoader);
        Objects.requireNonNull(pluginConfigurationObservableFactory);
        this.pluginCreator = Objects.requireNonNull(pluginCreator);
        this.pluginConfigurationConverter = Objects.requireNonNull(pluginConfigurationConverter);
        this.pluginProviders = Objects.requireNonNull(pluginProviderLoader.getPluginProviders());
        this.pluginBeanFactoryProvider = Objects.requireNonNull(pluginBeanFactoryProvider);
        this.pluginConfigurationObservableFactory = pluginConfigurationObservableFactory;
        if (this.pluginProviders.isEmpty()) {
            throw new RuntimeException("Data Prepper requires at least one PluginProvider. Your Data Prepper configuration may be missing the org.opensearch.dataprepper.plugin.PluginProvider file.");
        }
    }

    public <T> T loadPlugin(Class<T> baseClass, PluginSetting pluginSetting, Object ... args) {
        String pluginName = pluginSetting.getName();
        Class<T> pluginClass = this.getPluginClass(baseClass, pluginName);
        ComponentPluginArgumentsContext constructionContext = this.getConstructionContext(pluginSetting, pluginClass, null);
        return this.pluginCreator.newPluginInstance(pluginClass, constructionContext, pluginName, args);
    }

    public <T> T loadPlugin(Class<T> baseClass, PluginSetting pluginSetting, SinkContext sinkContext) {
        String pluginName = pluginSetting.getName();
        Class<T> pluginClass = this.getPluginClass(baseClass, pluginName);
        ComponentPluginArgumentsContext constructionContext = this.getConstructionContext(pluginSetting, pluginClass, sinkContext);
        return this.pluginCreator.newPluginInstance(pluginClass, constructionContext, pluginName, new Object[0]);
    }

    public <T> List<T> loadPlugins(Class<T> baseClass, PluginSetting pluginSetting, Function<Class<? extends T>, Integer> numberOfInstancesFunction) {
        String pluginName = pluginSetting.getName();
        Class<T> pluginClass = this.getPluginClass(baseClass, pluginName);
        Integer numberOfInstances = numberOfInstancesFunction.apply(pluginClass);
        if (numberOfInstances == null || numberOfInstances < 0) {
            throw new IllegalArgumentException("The numberOfInstances must be provided as a non-negative integer.");
        }
        ComponentPluginArgumentsContext constructionContext = this.getConstructionContext(pluginSetting, pluginClass, null);
        ArrayList<T> plugins = new ArrayList<T>(numberOfInstances);
        for (int i = 0; i < numberOfInstances; ++i) {
            plugins.add(this.pluginCreator.newPluginInstance(pluginClass, constructionContext, pluginName, new Object[0]));
        }
        return plugins;
    }

    private <T> ComponentPluginArgumentsContext getConstructionContext(PluginSetting pluginSetting, Class<? extends T> pluginClass, SinkContext sinkContext) {
        DataPrepperPlugin pluginAnnotation = pluginClass.getAnnotation(DataPrepperPlugin.class);
        Class pluginConfigurationType = pluginAnnotation.pluginConfigurationType();
        Object configuration = this.pluginConfigurationConverter.convert(pluginConfigurationType, pluginSetting);
        PluginConfigObservable pluginConfigObservable = this.pluginConfigurationObservableFactory.createDefaultPluginConfigObservable(this.pluginConfigurationConverter, pluginConfigurationType, pluginSetting);
        Class[] markersToScan = pluginAnnotation.packagesToScan();
        BeanFactory beanFactory = this.pluginBeanFactoryProvider.createPluginSpecificContext(markersToScan, configuration, pluginSetting);
        return new ComponentPluginArgumentsContext.Builder().withPluginSetting(pluginSetting).withPipelineDescription((PipelineDescription)pluginSetting).withPluginConfiguration(configuration).withPluginFactory(this).withSinkContext(sinkContext).withBeanFactory(beanFactory).withPluginConfigurationObservable(pluginConfigObservable).withTypeArgumentSuppliers(this.applicationContextToTypedSuppliers.getArgumentsSuppliers()).build();
    }

    private <T> Class<? extends T> getPluginClass(Class<T> baseClass, String pluginName) {
        Class pluginClass = this.pluginProviders.stream().map(pluginProvider -> pluginProvider.findPluginClass(baseClass, pluginName)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new NoPluginFoundException("Unable to find a plugin named '" + pluginName + "'. Please ensure that plugin is annotated with appropriate values."));
        this.handleDefinedPlugins(pluginClass, baseClass, pluginName);
        return pluginClass;
    }

    private <T> void handleDefinedPlugins(Class<? extends T> pluginClass, Class<? extends T> pluginTypeClass, String pluginName) {
        DefinedPlugin definedPlugin = new DefinedPlugin(pluginClass, pluginTypeClass, pluginName);
        this.definedPluginConsumers.forEach(definedPluginConsumer -> definedPluginConsumer.accept(definedPlugin));
    }
}

