/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.plugin.PluginConfigObserver;
import org.opensearch.dataprepper.plugin.PluginConfigurationConverter;

public class DefaultPluginConfigObservable
implements PluginConfigObservable {
    private final Map<PluginConfigObserver, Boolean> pluginConfigObserverBooleanMap = new ConcurrentHashMap<PluginConfigObserver, Boolean>();
    private final PluginConfigurationConverter pluginConfigurationConverter;
    private final Class<?> pluginConfigClass;
    private final PluginSetting rawPluginSettings;

    public DefaultPluginConfigObservable(PluginConfigurationConverter pluginConfigurationConverter, Class<?> pluginConfigClass, PluginSetting rawPluginSettings) {
        this.pluginConfigurationConverter = pluginConfigurationConverter;
        this.pluginConfigClass = pluginConfigClass;
        this.rawPluginSettings = rawPluginSettings;
    }

    public boolean addPluginConfigObserver(PluginConfigObserver pluginConfigObserver) {
        this.pluginConfigObserverBooleanMap.put(pluginConfigObserver, true);
        return true;
    }

    public void update() {
        Object newPluginConfiguration = this.pluginConfigurationConverter.convert(this.pluginConfigClass, this.rawPluginSettings);
        this.pluginConfigObserverBooleanMap.keySet().forEach(pluginConfigObserver -> pluginConfigObserver.update(newPluginConfiguration));
    }
}

