/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.loggenerator;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class CsvLogFaker {
    private static final int VPC_FLOW_LOGS_VERSION = 2;
    private static final String[] SRCPORT = new String[]{"20", "22", "80", "443"};
    private static final String[] ACTION = new String[]{"ACCEPT", "REJECT"};
    private static final String[] LOG_STATUS = new String[]{"OK", "NODATA", "SKIPDATA"};
    private final Random random = new Random();

    public String generateRandomStandardVPCFlowLog() {
        String destinationPort = String.valueOf(49152 + this.random.nextInt(16383));
        String packets = String.valueOf(this.random.nextInt(255));
        int startTime = (int)System.currentTimeMillis();
        int endTime = startTime + 1 + this.random.nextInt(999);
        String bytes = String.valueOf(this.random.nextInt(1001) + 4000);
        List<String> logAttributes = Arrays.asList(String.valueOf(2), this.generateAccountId(), this.generateInterfaceId(), this.randomIpV4Address(), this.randomIpV4Address(), this.getRandomElementOf(SRCPORT), destinationPort, packets, bytes, String.valueOf(startTime), String.valueOf(endTime), this.getRandomElementOf(ACTION), this.getRandomElementOf(LOG_STATUS));
        String log = String.join((CharSequence)" ", logAttributes);
        return log;
    }

    private String generateInterfaceId() {
        String prefix = "eni-";
        return "eni-" + this.generateRandomDigitString(16);
    }

    private String generateAccountId() {
        int accountIdLength = 12;
        return this.generateRandomDigitString(12);
    }

    private String generateRandomDigitString(int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(this.random.nextInt(10));
        }
        return result.toString();
    }

    private String getRandomElementOf(String[] array) {
        return array[this.random.nextInt(array.length)];
    }

    private String randomIpV4Address() {
        return this.random.nextInt(255) + "." + this.random.nextInt(255) + "." + this.random.nextInt(255) + "." + this.random.nextInt(255);
    }
}

