/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.useragent;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Function;
import ua_parser.Client;
import ua_parser.Device;
import ua_parser.OS;
import ua_parser.Parser;
import ua_parser.UserAgent;

class CaffeineCachingParser
extends Parser {
    private final Cache<String, Client> clientCache;
    private final Cache<String, UserAgent> userAgentCache;
    private final Cache<String, Device> deviceCache;
    private final Cache<String, OS> osCache;

    CaffeineCachingParser(long cacheSize) {
        this.userAgentCache = CaffeineCachingParser.createCache(cacheSize);
        this.clientCache = CaffeineCachingParser.createCache(cacheSize);
        this.deviceCache = CaffeineCachingParser.createCache(cacheSize);
        this.osCache = CaffeineCachingParser.createCache(cacheSize);
    }

    public Client parse(String agentString) {
        return this.parseCaching(agentString, this.clientCache, x$0 -> super.parse(x$0));
    }

    public UserAgent parseUserAgent(String agentString) {
        return this.parseCaching(agentString, this.userAgentCache, x$0 -> super.parseUserAgent(x$0));
    }

    public Device parseDevice(String agentString) {
        return this.parseCaching(agentString, this.deviceCache, x$0 -> super.parseDevice(x$0));
    }

    public OS parseOS(String agentString) {
        return this.parseCaching(agentString, this.osCache, x$0 -> super.parseOS(x$0));
    }

    private <T> T parseCaching(String agentString, Cache<String, T> cache, Function<String, T> parseFunction) {
        if (agentString == null) {
            return null;
        }
        return (T)cache.get((Object)agentString, parseFunction);
    }

    private static <T> Cache<String, T> createCache(long maximumSize) {
        return Caffeine.newBuilder().maximumSize(maximumSize).build();
    }
}

