/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import org.opensearch.dataprepper.core.pipeline.PipelinesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPipelinesHandler
implements HttpHandler {
    private final PipelinesProvider pipelinesProvider;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Logger LOG = LoggerFactory.getLogger(GetPipelinesHandler.class);

    public GetPipelinesHandler(PipelinesProvider pipelinesProvider) {
        this.pipelinesProvider = pipelinesProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equals("GET")) {
            exchange.sendResponseHeaders(405, 0L);
            exchange.getResponseBody().close();
            return;
        }
        try {
            ArrayList pipelineModels = new ArrayList(this.pipelinesProvider.getPipelinesDataFlowModel().getPipelines().values());
            byte[] response = OBJECT_MAPPER.writeValueAsString(pipelineModels).getBytes();
            exchange.getResponseHeaders().add("Content-Type", "text/plain; charset=UTF-8");
            exchange.sendResponseHeaders(200, response.length);
            exchange.getResponseBody().write(response);
        }
        catch (Exception e) {
            this.LOG.error("Caught exception listing pipelines", (Throwable)e);
            exchange.sendResponseHeaders(500, 0L);
        }
        finally {
            exchange.getResponseBody().close();
        }
    }
}

