/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.dataprepper.core.acknowledgements.InactiveAcknowledgementSetManager;
import org.opensearch.dataprepper.core.parser.DataFlowComponent;
import org.opensearch.dataprepper.core.pipeline.PipelineConnector;
import org.opensearch.dataprepper.core.pipeline.router.RouterGetRecordStrategy;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventBuilder;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.InternalEventHandle;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.JacksonSpan;
import org.opensearch.dataprepper.model.trace.Span;

public class RouterCopyRecordStrategy
implements RouterGetRecordStrategy {
    private Set<Record> routedRecords;
    private Set<Record> referencedRecords;
    private AcknowledgementSetManager acknowledgementSetManager;
    private EventFactory eventFactory;

    public <C> RouterCopyRecordStrategy(EventFactory eventFactory, AcknowledgementSetManager acknowledgementSetManager, Collection<DataFlowComponent<C>> dataFlowComponents) {
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.eventFactory = eventFactory;
        this.routedRecords = null;
        this.referencedRecords = new HashSet<Record>();
        if (dataFlowComponents.size() > 1) {
            for (DataFlowComponent<C> dataFlowComponent : dataFlowComponents) {
                if (!(dataFlowComponent.getComponent() instanceof PipelineConnector)) continue;
                this.routedRecords = new HashSet<Record>();
                break;
            }
        }
    }

    Set<Record> getReferencedRecords() {
        return this.referencedRecords;
    }

    private void acquireEventReference(Record record) {
        if (this.acknowledgementSetManager == InactiveAcknowledgementSetManager.getInstance() || record.getData() == null) {
            return;
        }
        if (this.referencedRecords.contains(record) || this.routedRecords != null && this.routedRecords.contains(record)) {
            EventHandle eventHandle = ((JacksonEvent)record.getData()).getEventHandle();
            if (eventHandle != null && eventHandle instanceof InternalEventHandle) {
                ((InternalEventHandle)eventHandle).acquireReference();
            }
        } else if (!this.referencedRecords.contains(record)) {
            this.referencedRecords.add(record);
        }
    }

    @Override
    public Record getRecord(Record record) {
        if (this.routedRecords == null) {
            this.acquireEventReference(record);
            return record;
        }
        if (!this.routedRecords.contains(record)) {
            this.acquireEventReference(record);
            this.routedRecords.add(record);
            return record;
        }
        if (record.getData() instanceof JacksonSpan) {
            try {
                Span spanEvent = (Span)record.getData();
                JacksonSpan newSpanEvent = JacksonSpan.fromSpan((Span)spanEvent);
                return new Record((Object)newSpanEvent);
            }
            catch (Exception spanEvent) {}
        } else if (record.getData() instanceof Event) {
            try {
                Record newRecord;
                Event recordEvent = (Event)record.getData();
                InternalEventHandle internalHandle = (InternalEventHandle)recordEvent.getEventHandle();
                if (internalHandle != null && internalHandle.hasAcknowledgementSet()) {
                    EventMetadata eventMetadata = recordEvent.getMetadata();
                    EventBuilder eventBuilder = (EventBuilder)((EventBuilder)this.eventFactory.eventBuilder(EventBuilder.class)).withEventMetadata(eventMetadata).withData((Object)recordEvent.toMap());
                    JacksonEvent newRecordEvent = (JacksonEvent)eventBuilder.build();
                    internalHandle.addEventHandle(newRecordEvent.getEventHandle());
                    newRecord = new Record((Object)newRecordEvent);
                    this.acquireEventReference(newRecord);
                } else {
                    JacksonEvent newRecordEvent = JacksonEvent.fromEvent((Event)recordEvent);
                    newRecord = new Record((Object)newRecordEvent);
                }
                return newRecord;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return record;
    }

    @Override
    public Collection<Record> getAllRecords(Collection<Record> allRecords) {
        if (this.routedRecords == null) {
            allRecords.stream().forEach(record -> this.acquireEventReference((Record)record));
            return allRecords;
        }
        if (this.routedRecords.isEmpty()) {
            allRecords.stream().forEach(record -> this.acquireEventReference((Record)record));
            this.routedRecords.addAll(allRecords);
            return allRecords;
        }
        ArrayList<Record> newRecords = new ArrayList<Record>();
        for (Record record2 : allRecords) {
            newRecords.add(this.getRecord(record2));
        }
        return newRecords;
    }
}

