/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.server;

import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.inject.Provider;
import javax.net.ssl.TrustManagerFactory;
import org.opensearch.dataprepper.core.peerforwarder.ForwardingAuthentication;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderHttpService;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerForwarderHttpServerProvider
implements Provider<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(PeerForwarderHttpServerProvider.class);
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final CertificateProviderFactory certificateProviderFactory;
    private final PeerForwarderHttpService peerForwarderHttpService;

    public PeerForwarderHttpServerProvider(PeerForwarderConfiguration peerForwarderConfiguration, CertificateProviderFactory certificateProviderFactory, PeerForwarderHttpService peerForwarderHttpService) {
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.certificateProviderFactory = certificateProviderFactory;
        this.peerForwarderHttpService = peerForwarderHttpService;
    }

    public Server get() {
        ServerBuilder sb = Server.builder();
        sb.disableServerHeader();
        if (this.peerForwarderConfiguration.isSsl()) {
            CertificateProvider certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            Certificate certificate = certificateProvider.getCertificate();
            LOG.info("Creating http source with SSL/TLS enabled.");
            sb.https(this.peerForwarderConfiguration.getServerPort()).tls((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8)));
            if (this.peerForwarderConfiguration.getAuthentication() == ForwardingAuthentication.MUTUAL_TLS) {
                if (this.peerForwarderConfiguration.isSslFingerprintVerificationOnly()) {
                    FingerprintTrustManagerFactory fingerprintTrustManagerFactory = new FingerprintTrustManagerFactory(new String[]{certificate.getFingerprint()});
                    sb.tlsCustomizer(sslContextBuilder -> sslContextBuilder.trustManager((TrustManagerFactory)fingerprintTrustManagerFactory).clientAuth(ClientAuth.REQUIRE));
                } else {
                    sb.tlsCustomizer(sslContextBuilder -> sslContextBuilder.trustManager((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8))).clientAuth(ClientAuth.REQUIRE));
                }
            }
        } else {
            LOG.warn("Creating Peer Forwarder server without SSL/TLS. This is not secure.");
            sb.http(this.peerForwarderConfiguration.getServerPort());
        }
        sb.maxNumConnections(this.peerForwarderConfiguration.getMaxConnectionCount());
        sb.requestTimeout(Duration.ofMillis(this.peerForwarderConfiguration.getRequestTimeout()));
        int threadCount = this.peerForwarderConfiguration.getServerThreadCount();
        ScheduledThreadPoolExecutor blockingTaskExecutor = new ScheduledThreadPoolExecutor(threadCount);
        sb.blockingTaskExecutor((ScheduledExecutorService)blockingTaskExecutor, true);
        sb.annotatedService("/event/forward", (Object)this.peerForwarderHttpService);
        return sb.build();
    }
}

