/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.codec;

import java.io.ObjectInputFilter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingObjectInputFilter
implements ObjectInputFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingObjectInputFilter.class);
    private final ObjectInputFilter filter;

    public LoggingObjectInputFilter(ObjectInputFilter filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        ObjectInputFilter.Status status = this.filter.checkInput(filterInfo);
        if (status == ObjectInputFilter.Status.REJECTED) {
            LOG.warn("Unable to deserialize: {}", filterInfo.serialClass());
        }
        return status;
    }
}

