/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.model.PeerForwardingEvents;

public class JavaPeerForwarderCodec
implements PeerForwarderCodec {
    private final ObjectInputFilter filter;

    public JavaPeerForwarderCodec(ObjectInputFilter filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public byte[] serialize(PeerForwardingEvents events) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(events);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public PeerForwardingEvents deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            PeerForwardingEvents peerForwardingEvents;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
                objectInputStream.setObjectInputFilter(this.filter);
                peerForwardingEvents = (PeerForwardingEvents)objectInputStream.readObject();
            }
            return peerForwardingEvents;
        }
    }
}

