/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import java.util.Map;
import java.util.Set;
import org.opensearch.dataprepper.core.peerforwarder.LocalPeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderReceiveBuffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.peerforwarder.RequiresPeerForwarding;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;

public class LocalModePeerForwarderProvider
implements PeerForwarderProvider {
    private final PeerForwarderProvider peerForwarderProvider;
    private boolean isRemotePeerForwarderRegistered;

    public LocalModePeerForwarderProvider(PeerForwarderProvider peerForwarderProvider) {
        this.peerForwarderProvider = peerForwarderProvider;
        this.isRemotePeerForwarderRegistered = false;
    }

    @Override
    public PeerForwarder register(String pipelineName, Processor processor, String pluginId, Set<String> identificationKeys, Integer pipelineWorkerThreads) {
        if (((RequiresPeerForwarding)processor).isForLocalProcessingOnly(null)) {
            return new LocalPeerForwarder();
        }
        this.isRemotePeerForwarderRegistered = true;
        return this.peerForwarderProvider.register(pipelineName, processor, pluginId, identificationKeys, pipelineWorkerThreads);
    }

    @Override
    public boolean isPeerForwardingRequired() {
        return this.isRemotePeerForwarderRegistered;
    }

    @Override
    public Map<String, Map<String, PeerForwarderReceiveBuffer<Record<Event>>>> getPipelinePeerForwarderReceiveBufferMap() {
        return this.isRemotePeerForwarderRegistered ? this.peerForwarderProvider.getPipelinePeerForwarderReceiveBufferMap() : Map.of();
    }

    @Override
    public boolean arePeersConfigured() {
        return this.isRemotePeerForwarderRegistered ? this.peerForwarderProvider.arePeersConfigured() : false;
    }
}

