/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.core.parser.config.MetricTagFilter;
import org.opensearch.dataprepper.core.parser.model.CircuitBreakerConfig;
import org.opensearch.dataprepper.core.parser.model.EmfConfig;
import org.opensearch.dataprepper.core.parser.model.MetricRegistryType;
import org.opensearch.dataprepper.core.parser.model.SourceCoordinationConfig;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.pipeline.PipelineShutdownOption;
import org.opensearch.dataprepper.event.EventConfiguration;
import org.opensearch.dataprepper.event.EventConfigurationContainer;
import org.opensearch.dataprepper.model.configuration.PipelineExtensions;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugin.ExperimentalConfiguration;
import org.opensearch.dataprepper.plugin.ExperimentalConfigurationContainer;
import org.opensearch.dataprepper.plugin.ExtensionsConfiguration;

public class DataPrepperConfiguration
implements ExtensionsConfiguration,
EventConfigurationContainer,
ExperimentalConfigurationContainer {
    static final Duration DEFAULT_SHUTDOWN_DURATION = Duration.ofSeconds(30L);
    public static final String DEFAULT_FAILURE_PIPELINE_NAME = "dlq_pipeline";
    private static final String DEFAULT_SOURCE_COORDINATION_STORE = "in_memory";
    static final int MAX_TAGS_NUMBER = 3;
    private static final List<MetricRegistryType> DEFAULT_METRIC_REGISTRY_TYPE = Collections.singletonList(MetricRegistryType.Prometheus);
    private static final PipelineShutdownOption DEFAULT_PIPELINE_SHUTDOWN = PipelineShutdownOption.ON_ANY_PIPELINE_FAILURE;
    private int serverPort = 4900;
    private boolean ssl = true;
    private String keyStoreFilePath = "";
    private String keyStorePassword = "";
    private String privateKeyPassword = "";
    private List<MetricRegistryType> metricRegistries = DEFAULT_METRIC_REGISTRY_TYPE;
    private PluginModel authentication;
    private CircuitBreakerConfig circuitBreakerConfig;
    private SourceCoordinationConfig sourceCoordinationConfig;
    private PipelineShutdownOption pipelineShutdown;
    private EventConfiguration eventConfiguration;
    private Map<String, String> metricTags = new HashMap<String, String>();
    private List<MetricTagFilter> metricTagFilters = new LinkedList<MetricTagFilter>();
    private List<String> disabledMetrics = new LinkedList<String>();
    private EmfConfig emf = new EmfConfig();
    private PeerForwarderConfiguration peerForwarderConfiguration;
    private Duration processorShutdownTimeout;
    private Duration sinkShutdownTimeout;
    private ExperimentalConfiguration experimental;
    private PipelineExtensions pipelineExtensions;
    private String failurePipelineName = "dlq_pipeline";
    public static final DataPrepperConfiguration DEFAULT_CONFIG = new DataPrepperConfiguration();

    public DataPrepperConfiguration() {
    }

    @JsonCreator
    public DataPrepperConfiguration(@JsonProperty(value="ssl") Boolean ssl, @JsonProperty(value="key_store_file_path") @JsonAlias(value={"keyStoreFilePath"}) String keyStoreFilePath, @JsonProperty(value="key_store_password") @JsonAlias(value={"keyStorePassword"}) String keyStorePassword, @JsonProperty(value="private_key_password") @JsonAlias(value={"privateKeyPassword"}) String privateKeyPassword, @JsonProperty(value="server_port") @JsonAlias(value={"serverPort"}) String serverPort, @JsonProperty(value="metric_registries") @JsonAlias(value={"metricRegistries"}) List<MetricRegistryType> metricRegistries, @JsonProperty(value="authentication") PluginModel authentication, @JsonProperty(value="metric_tags") @JsonAlias(value={"metricTags"}) Map<String, String> metricTags, @JsonProperty(value="metric_tag_filters") List<MetricTagFilter> metricTagFilters, @JsonProperty(value="disabled_metrics") List<String> disabledMetrics, @JsonProperty(value="emf_metrics") EmfConfig emf, @JsonProperty(value="peer_forwarder") PeerForwarderConfiguration peerForwarderConfiguration, @JsonProperty(value="processor_shutdown_timeout") @JsonAlias(value={"processorShutdownTimeout"}) Duration processorShutdownTimeout, @JsonProperty(value="sink_shutdown_timeout") @JsonAlias(value={"sinkShutdownTimeout"}) Duration sinkShutdownTimeout, @JsonProperty(value="circuit_breakers") CircuitBreakerConfig circuitBreakerConfig, @JsonProperty(value="source_coordination") SourceCoordinationConfig sourceCoordinationConfig, @JsonProperty(value="pipeline_shutdown") PipelineShutdownOption pipelineShutdown, @JsonProperty(value="event") EventConfiguration eventConfiguration, @JsonProperty(value="experimental") ExperimentalConfiguration experimental, @JsonProperty(value="extensions") @JsonInclude(value=JsonInclude.Include.NON_NULL) @JsonSetter(nulls=Nulls.SKIP) PipelineExtensions pipelineExtensions) {
        this.authentication = authentication;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.sourceCoordinationConfig = Objects.isNull(sourceCoordinationConfig) ? new SourceCoordinationConfig(new PluginModel(DEFAULT_SOURCE_COORDINATION_STORE, Collections.emptyMap()), null) : sourceCoordinationConfig;
        this.pipelineShutdown = pipelineShutdown != null ? pipelineShutdown : DEFAULT_PIPELINE_SHUTDOWN;
        this.eventConfiguration = eventConfiguration != null ? eventConfiguration : EventConfiguration.defaultConfiguration();
        this.setSsl(ssl);
        this.keyStoreFilePath = keyStoreFilePath != null ? keyStoreFilePath : "";
        this.keyStorePassword = keyStorePassword != null ? keyStorePassword : "";
        this.privateKeyPassword = privateKeyPassword != null ? privateKeyPassword : "";
        this.metricRegistries = metricRegistries != null && !metricRegistries.isEmpty() ? metricRegistries : DEFAULT_METRIC_REGISTRY_TYPE;
        this.setMetricTags(metricTags);
        this.setMetricTagFilters(metricTagFilters);
        this.setServerPort(serverPort);
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.disabledMetrics = disabledMetrics;
        this.emf = emf != null ? emf : new EmfConfig();
        Duration duration = this.processorShutdownTimeout = processorShutdownTimeout != null ? processorShutdownTimeout : DEFAULT_SHUTDOWN_DURATION;
        if (this.processorShutdownTimeout.isNegative()) {
            throw new IllegalArgumentException("processorShutdownTimeout must be non-negative.");
        }
        Duration duration2 = this.sinkShutdownTimeout = sinkShutdownTimeout != null ? sinkShutdownTimeout : DEFAULT_SHUTDOWN_DURATION;
        if (this.sinkShutdownTimeout.isNegative()) {
            throw new IllegalArgumentException("sinkShutdownTimeout must be non-negative.");
        }
        this.experimental = experimental != null ? experimental : ExperimentalConfiguration.defaultConfiguration();
        this.pipelineExtensions = pipelineExtensions;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getFailurePipelineName() {
        return this.failurePipelineName;
    }

    public boolean ssl() {
        return this.ssl;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public List<MetricRegistryType> getMetricRegistryTypes() {
        return this.metricRegistries;
    }

    public Map<String, String> getMetricTags() {
        return this.metricTags;
    }

    public List<MetricTagFilter> getMetricTagFilters() {
        return this.metricTagFilters;
    }

    public List<String> getDisabledMetrics() {
        return this.disabledMetrics != null ? this.disabledMetrics : Collections.emptyList();
    }

    public Map<String, String> getEmfAdditionalProperties() {
        return this.emf.getAdditionalProperties();
    }

    private void setSsl(Boolean ssl) {
        if (ssl != null) {
            this.ssl = ssl;
        }
    }

    public PluginModel getAuthentication() {
        return this.authentication;
    }

    public PeerForwarderConfiguration getPeerForwarderConfiguration() {
        return this.peerForwarderConfiguration;
    }

    private void setServerPort(String serverPort) {
        if (serverPort != null && !serverPort.isEmpty()) {
            try {
                int port = Integer.parseInt(serverPort);
                if (port <= 0) {
                    throw new IllegalArgumentException("Server port must be a positive integer");
                }
                this.serverPort = port;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Server port must be a positive integer");
            }
        }
    }

    private void setMetricTags(Map<String, String> metricTags) {
        if (metricTags != null) {
            if (metricTags.size() > 3) {
                throw new IllegalArgumentException("metricTags cannot be more than 3");
            }
            this.metricTags = metricTags;
        }
    }

    public void setMetricTagFilters(List<MetricTagFilter> metricTagFilters) {
        if (metricTagFilters != null) {
            metricTagFilters.forEach(metricTagFilter -> {
                if (metricTagFilter.getTags() != null && metricTagFilter.getTags().size() > 3) {
                    throw new IllegalArgumentException(String.format("Each metric tag filter may have no more than %s tags.", 3));
                }
            });
            this.metricTagFilters = metricTagFilters;
        }
    }

    public Duration getProcessorShutdownTimeout() {
        return this.processorShutdownTimeout;
    }

    public Duration getSinkShutdownTimeout() {
        return this.sinkShutdownTimeout;
    }

    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    public SourceCoordinationConfig getSourceCoordinationConfig() {
        return this.sourceCoordinationConfig;
    }

    public PipelineShutdownOption getPipelineShutdown() {
        return this.pipelineShutdown;
    }

    public EventConfiguration getEventConfiguration() {
        return this.eventConfiguration;
    }

    public PipelineExtensions getPipelineExtensions() {
        return this.pipelineExtensions;
    }

    public ExperimentalConfiguration getExperimental() {
        return this.experimental;
    }
}

