/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.meter;

class EMFMetricUtils {
    static final double MINIMUM_ALLOWED_VALUE = 8.51592E-109;
    static final double MAXIMUM_ALLOWED_VALUE = 1.174271E108;

    EMFMetricUtils() {
    }

    static double clampMetricValue(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        double magnitude = Math.abs(value);
        if (magnitude == 0.0) {
            return 0.0;
        }
        double clampedMag = Math.min(Math.max(magnitude, 8.51592E-109), 1.174271E108);
        return Math.copySign(clampedMag, value);
    }
}

