/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import java.time.Duration;

public class DataPrepperShutdownOptions {
    private final Duration bufferReadTimeout;
    private final Duration bufferDrainTimeout;

    public static DataPrepperShutdownOptions defaultOptions() {
        return new DataPrepperShutdownOptions(DataPrepperShutdownOptions.builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataPrepperShutdownOptions(Builder builder) {
        this.bufferReadTimeout = builder.bufferReadTimeout;
        this.bufferDrainTimeout = builder.bufferDrainTimeout;
        if (this.bufferReadTimeout != null && this.bufferDrainTimeout != null && this.bufferReadTimeout.compareTo(this.bufferDrainTimeout) > 0) {
            throw new IllegalArgumentException("Buffer read timeout cannot be greater than buffer drain timeout");
        }
    }

    public Duration getBufferReadTimeout() {
        return this.bufferReadTimeout;
    }

    public Duration getBufferDrainTimeout() {
        return this.bufferDrainTimeout;
    }

    public static class Builder {
        private Duration bufferReadTimeout;
        private Duration bufferDrainTimeout;

        private Builder() {
        }

        public Builder withBufferReadTimeout(Duration bufferReadTimeout) {
            this.bufferReadTimeout = bufferReadTimeout;
            return this;
        }

        public Builder withBufferDrainTimeout(Duration bufferDrainTimeout) {
            this.bufferDrainTimeout = bufferDrainTimeout;
            return this;
        }

        public DataPrepperShutdownOptions build() {
            return new DataPrepperShutdownOptions(this);
        }
    }
}

