/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.rank_eval;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankEvalHit
implements JsonpSerializable {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    private final double score;
    public static final JsonpDeserializer<RankEvalHit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalHit::setupRankEvalHitDeserializer);

    private RankEvalHit(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.type = builder.type;
        this.score = ApiTypeHelper.requireNonNull(builder.score, this, "score");
    }

    public static RankEvalHit of(Function<Builder, ObjectBuilder<RankEvalHit>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    public final double score() {
        return this.score;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_score");
        generator.write(this.score);
    }

    protected static void setupRankEvalHitDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "_score");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RankEvalHit> {
        private String id;
        private String index;
        @Nullable
        private String type;
        private Double score;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder score(double value) {
            this.score = value;
            return this;
        }

        @Override
        public RankEvalHit build() {
            this._checkSingleUse();
            return new RankEvalHit(this);
        }
    }
}

