/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkResponse
implements JsonpSerializable {
    private final boolean errors;
    private final List<BulkResponseItem> items;
    private final long took;
    @Nullable
    private final Long ingestTook;
    public static final JsonpDeserializer<BulkResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkResponse::setupBulkResponseDeserializer);

    private BulkResponse(Builder builder) {
        this.errors = ApiTypeHelper.requireNonNull(builder.errors, this, "errors");
        this.items = ApiTypeHelper.unmodifiableRequired(builder.items, (Object)this, "items");
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.ingestTook = builder.ingestTook;
    }

    public static BulkResponse of(Function<Builder, ObjectBuilder<BulkResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean errors() {
        return this.errors;
    }

    public final List<BulkResponseItem> items() {
        return this.items;
    }

    public final long took() {
        return this.took;
    }

    @Nullable
    public final Long ingestTook() {
        return this.ingestTook;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("errors");
        generator.write(this.errors);
        if (ApiTypeHelper.isDefined(this.items)) {
            generator.writeKey("items");
            generator.writeStartArray();
            for (BulkResponseItem item0 : this.items) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("took");
        generator.write(this.took);
        if (this.ingestTook != null) {
            generator.writeKey("ingest_took");
            generator.write(this.ingestTook.longValue());
        }
    }

    protected static void setupBulkResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errors, JsonpDeserializer.booleanDeserializer(), "errors");
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(BulkResponseItem._DESERIALIZER), "items");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::ingestTook, JsonpDeserializer.longDeserializer(), "ingest_took");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BulkResponse> {
        private Boolean errors;
        private List<BulkResponseItem> items;
        private Long took;
        @Nullable
        private Long ingestTook;

        public final Builder errors(boolean value) {
            this.errors = value;
            return this;
        }

        public final Builder items(List<BulkResponseItem> list) {
            this.items = Builder._listAddAll(this.items, list);
            return this;
        }

        public final Builder items(BulkResponseItem value, BulkResponseItem ... values) {
            this.items = Builder._listAdd(this.items, value, values);
            return this;
        }

        public final Builder items(Function<BulkResponseItem.Builder, ObjectBuilder<BulkResponseItem>> fn) {
            return this.items(fn.apply(new BulkResponseItem.Builder()).build(), new BulkResponseItem[0]);
        }

        public final Builder took(long value) {
            this.took = value;
            return this;
        }

        public final Builder ingestTook(@Nullable Long value) {
            this.ingestTook = value;
            return this;
        }

        @Override
        public BulkResponse build() {
            this._checkSingleUse();
            return new BulkResponse(this);
        }
    }
}

