/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.StandardNumberProperty;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FloatNumberProperty
extends StandardNumberProperty
implements PropertyVariant {
    @Nullable
    private final Float nullValue;
    public static final JsonpDeserializer<FloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FloatNumberProperty::setupFloatNumberPropertyDeserializer);

    private FloatNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static FloatNumberProperty of(Function<Builder, ObjectBuilder<FloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Float;
    }

    @Nullable
    public final Float nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "float");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write((double)this.nullValue.floatValue());
        }
    }

    protected static void setupFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        StandardNumberProperty.setupStandardNumberPropertyDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.floatDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends StandardNumberProperty.AbstractBuilder<Builder>
    implements ObjectBuilder<FloatNumberProperty> {
        @Nullable
        private Float nullValue;

        public final Builder nullValue(@Nullable Float value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FloatNumberProperty build() {
            this._checkSingleUse();
            return new FloatNumberProperty(this);
        }
    }
}

