/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.SynonymFormat;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SynonymTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean expand;
    @Nullable
    private final SynonymFormat format;
    @Nullable
    private final Boolean lenient;
    private final List<String> synonyms;
    @Nullable
    private final String synonymsPath;
    @Nullable
    private final String tokenizer;
    @Nullable
    private final Boolean updateable;
    public static final JsonpDeserializer<SynonymTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SynonymTokenFilter::setupSynonymTokenFilterDeserializer);

    private SynonymTokenFilter(Builder builder) {
        super(builder);
        this.expand = builder.expand;
        this.format = builder.format;
        this.lenient = builder.lenient;
        this.synonyms = ApiTypeHelper.unmodifiable(builder.synonyms);
        this.synonymsPath = builder.synonymsPath;
        this.tokenizer = builder.tokenizer;
        this.updateable = builder.updateable;
    }

    public static SynonymTokenFilter of(Function<Builder, ObjectBuilder<SynonymTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Synonym;
    }

    @Nullable
    public final Boolean expand() {
        return this.expand;
    }

    @Nullable
    public final SynonymFormat format() {
        return this.format;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    public final List<String> synonyms() {
        return this.synonyms;
    }

    @Nullable
    public final String synonymsPath() {
        return this.synonymsPath;
    }

    @Nullable
    public final String tokenizer() {
        return this.tokenizer;
    }

    @Nullable
    public final Boolean updateable() {
        return this.updateable;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "synonym");
        super.serializeInternal(generator, mapper);
        if (this.expand != null) {
            generator.writeKey("expand");
            generator.write(this.expand.booleanValue());
        }
        if (this.format != null) {
            generator.writeKey("format");
            this.format.serialize(generator, mapper);
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.synonyms)) {
            generator.writeKey("synonyms");
            generator.writeStartArray();
            for (String item0 : this.synonyms) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.synonymsPath != null) {
            generator.writeKey("synonyms_path");
            generator.write(this.synonymsPath);
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            generator.write(this.tokenizer);
        }
        if (this.updateable != null) {
            generator.writeKey("updateable");
            generator.write(this.updateable.booleanValue());
        }
    }

    protected static void setupSynonymTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::expand, JsonpDeserializer.booleanDeserializer(), "expand");
        op.add(Builder::format, SynonymFormat._DESERIALIZER, "format");
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(Builder::synonyms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "synonyms");
        op.add(Builder::synonymsPath, JsonpDeserializer.stringDeserializer(), "synonyms_path");
        op.add(Builder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer");
        op.add(Builder::updateable, JsonpDeserializer.booleanDeserializer(), "updateable");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SynonymTokenFilter> {
        @Nullable
        private Boolean expand;
        @Nullable
        private SynonymFormat format;
        @Nullable
        private Boolean lenient;
        @Nullable
        private List<String> synonyms;
        @Nullable
        private String synonymsPath;
        @Nullable
        private String tokenizer;
        @Nullable
        private Boolean updateable;

        public final Builder expand(@Nullable Boolean value) {
            this.expand = value;
            return this;
        }

        public final Builder format(@Nullable SynonymFormat value) {
            this.format = value;
            return this;
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder synonyms(List<String> list) {
            this.synonyms = Builder._listAddAll(this.synonyms, list);
            return this;
        }

        public final Builder synonyms(String value, String ... values) {
            this.synonyms = Builder._listAdd(this.synonyms, value, values);
            return this;
        }

        public final Builder synonymsPath(@Nullable String value) {
            this.synonymsPath = value;
            return this;
        }

        public final Builder tokenizer(@Nullable String value) {
            this.tokenizer = value;
            return this;
        }

        public final Builder updateable(@Nullable Boolean value) {
            this.updateable = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SynonymTokenFilter build() {
            this._checkSingleUse();
            return new SynonymTokenFilter(this);
        }
    }
}

