/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace.http;

import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.DecodingService;
import java.time.Duration;
import java.util.Map;
import org.opensearch.dataprepper.armeria.authentication.ArmeriaHttpAuthenticationProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceSourceConfig;
import org.opensearch.dataprepper.plugins.source.oteltrace.http.ArmeriaHttpService;
import org.opensearch.dataprepper.plugins.source.oteltrace.http.HttpExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpService.class);
    private static final RetryInfoConfig DEFAULT_RETRY_INFO = new RetryInfoConfig(Duration.ofMillis(100L), Duration.ofMillis(2000L));
    private final PluginMetrics pluginMetrics;
    private final OTelTraceSourceConfig oTelTraceSourceConfig;
    private final OTelProtoCodec.OTelProtoDecoder otelProtoDecoder;
    private final PluginFactory pluginFactory;

    public HttpService(PluginMetrics pluginMetrics, OTelProtoCodec.OTelProtoDecoder otelProtoDecoder, OTelTraceSourceConfig oTelTraceSourceConfig, PluginFactory pluginFactory) {
        this.otelProtoDecoder = otelProtoDecoder;
        this.pluginMetrics = pluginMetrics;
        this.oTelTraceSourceConfig = oTelTraceSourceConfig;
        this.pluginFactory = pluginFactory;
    }

    public ArmeriaHttpService create(ServerBuilder serverBuilder, Buffer<Record<Object>> buffer) {
        RetryInfoConfig retryInfo = this.oTelTraceSourceConfig.getRetryInfo() != null ? this.oTelTraceSourceConfig.getRetryInfo() : DEFAULT_RETRY_INFO;
        ArmeriaHttpService httpService = new ArmeriaHttpService(buffer, this.otelProtoDecoder, this.pluginMetrics, this.oTelTraceSourceConfig.getRequestTimeoutInMillis());
        HttpExceptionHandler httpExceptionHandler = new HttpExceptionHandler(this.pluginMetrics, retryInfo.getMinDelay(), retryInfo.getMaxDelay());
        this.configureAuthentication(serverBuilder);
        if (CompressionOption.NONE.equals((Object)this.oTelTraceSourceConfig.getCompression())) {
            serverBuilder.annotatedService((Object)httpService, new Object[]{httpExceptionHandler});
        } else {
            serverBuilder.annotatedService((Object)httpService, DecodingService.newDecorator(), new Object[]{httpExceptionHandler});
        }
        return httpService;
    }

    private void configureAuthentication(ServerBuilder serverBuilder) {
        if (this.oTelTraceSourceConfig.getAuthentication() == null || this.oTelTraceSourceConfig.getAuthentication().getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel_trace_source http service without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-trace-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#authentication-configurations");
        } else {
            ArmeriaHttpAuthenticationProvider authenticationProvider = this.createAuthenticationProvider(this.oTelTraceSourceConfig.getAuthentication());
            authenticationProvider.getAuthenticationDecorator().ifPresent(arg_0 -> ((ServerBuilder)serverBuilder).decorator(arg_0));
        }
    }

    private ArmeriaHttpAuthenticationProvider createAuthenticationProvider(PluginModel authenticationConfiguration) {
        Map pluginSettings = authenticationConfiguration.getPluginSettings();
        return (ArmeriaHttpAuthenticationProvider)this.pluginFactory.loadPlugin(ArmeriaHttpAuthenticationProvider.class, new PluginSetting(authenticationConfiguration.getPluginName(), pluginSettings), new Object[0]);
    }
}

