/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace.grpc;

import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.grpc.GrpcServiceBuilder;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.GrpcRequestExceptionHandler;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.server.HealthGrpcService;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceGrpcService;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcService {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcService.class);
    private static final RetryInfoConfig DEFAULT_RETRY_INFO = new RetryInfoConfig(Duration.ofMillis(100L), Duration.ofMillis(2000L));
    private static final String PIPELINE_NAME_PLACEHOLDER = "${pipelineName}";
    public static final String REGEX_HEALTH = "regex:^/(?!health$).*$";
    private final OTelTraceSourceConfig oTelTraceSourceConfig;
    private final OTelProtoCodec.OTelProtoDecoder otelProtoDecoder;
    private final GrpcAuthenticationProvider authenticationProvider;
    private final PluginMetrics pluginMetrics;
    private final String pipelineName;

    public GrpcService(PluginFactory pluginFactory, OTelProtoCodec.OTelProtoDecoder otelProtoDecoder, OTelTraceSourceConfig oTelTraceSourceConfig, PluginMetrics pluginMetrics, String pipelineName) {
        this.oTelTraceSourceConfig = oTelTraceSourceConfig;
        this.otelProtoDecoder = otelProtoDecoder;
        this.pluginMetrics = pluginMetrics;
        this.pipelineName = pipelineName;
        this.authenticationProvider = this.createAuthenticationProvider(pluginFactory, oTelTraceSourceConfig);
    }

    public com.linecorp.armeria.server.grpc.GrpcService create(Buffer<Record<Object>> buffer, ServerBuilder serverBuilder) {
        OTelTraceGrpcService oTelTraceGrpcService = new OTelTraceGrpcService((int)((double)this.oTelTraceSourceConfig.getRequestTimeoutInMillis() * 0.8), this.otelProtoDecoder, buffer, this.pluginMetrics, null);
        List<ServerInterceptor> serverInterceptors = this.getAuthenticationInterceptor();
        GrpcServiceBuilder grpcServiceBuilder = com.linecorp.armeria.server.grpc.GrpcService.builder().useClientTimeoutHeader(false).useBlockingTaskExecutor(true).exceptionHandler(this.createGrpExceptionHandler());
        MethodDescriptor methodDescriptor = TraceServiceGrpc.getExportMethod();
        String oTelTraceSourcePath = this.oTelTraceSourceConfig.getPath();
        if (oTelTraceSourcePath != null) {
            String transformedOTelTraceSourcePath = oTelTraceSourcePath.replace(PIPELINE_NAME_PLACEHOLDER, this.pipelineName);
            grpcServiceBuilder.addService(transformedOTelTraceSourcePath, ServerInterceptors.intercept((BindableService)oTelTraceGrpcService, serverInterceptors), methodDescriptor);
        } else {
            grpcServiceBuilder.addService(ServerInterceptors.intercept((BindableService)oTelTraceGrpcService, serverInterceptors));
        }
        if (this.oTelTraceSourceConfig.hasHealthCheck()) {
            LOG.info("Health check is enabled");
            grpcServiceBuilder.addService((BindableService)new HealthGrpcService());
        }
        if (this.oTelTraceSourceConfig.hasProtoReflectionService()) {
            LOG.info("Proto reflection service is enabled");
            grpcServiceBuilder.addService(ProtoReflectionService.newInstance());
        }
        grpcServiceBuilder.enableUnframedRequests(this.oTelTraceSourceConfig.enableUnframedRequests());
        if (this.oTelTraceSourceConfig.getAuthentication() != null) {
            Optional optionalHttpAuthenticationService = this.authenticationProvider.getHttpAuthenticationService();
            if (this.oTelTraceSourceConfig.isUnauthenticatedHealthCheck()) {
                optionalHttpAuthenticationService.ifPresent(httpAuthenticationService -> serverBuilder.decorator(REGEX_HEALTH, httpAuthenticationService));
            } else {
                optionalHttpAuthenticationService.ifPresent(arg_0 -> ((ServerBuilder)serverBuilder).decorator(arg_0));
            }
        }
        return grpcServiceBuilder.build();
    }

    private List<ServerInterceptor> getAuthenticationInterceptor() {
        ServerInterceptor authenticationInterceptor = this.authenticationProvider.getAuthenticationInterceptor();
        if (authenticationInterceptor == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(authenticationInterceptor);
    }

    private GrpcAuthenticationProvider createAuthenticationProvider(PluginFactory pluginFactory, OTelTraceSourceConfig oTelTraceSourceConfig) {
        PluginModel authenticationConfiguration = oTelTraceSourceConfig.getAuthentication();
        if (authenticationConfiguration == null || authenticationConfiguration.getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel_trace_source grpc service without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-trace-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#authentication-configurations");
        }
        PluginSetting authenticationPluginSetting = authenticationConfiguration != null ? new PluginSetting(authenticationConfiguration.getPluginName(), authenticationConfiguration.getPluginSettings()) : new PluginSetting("unauthenticated", Collections.emptyMap());
        authenticationPluginSetting.setPipelineName(this.pipelineName);
        return (GrpcAuthenticationProvider)pluginFactory.loadPlugin(GrpcAuthenticationProvider.class, authenticationPluginSetting, new Object[0]);
    }

    private GrpcExceptionHandlerFunction createGrpExceptionHandler() {
        RetryInfoConfig retryInfo = this.oTelTraceSourceConfig.getRetryInfo() != null ? this.oTelTraceSourceConfig.getRetryInfo() : DEFAULT_RETRY_INFO;
        return new GrpcRequestExceptionHandler(this.pluginMetrics, retryInfo.getMinDelay(), retryInfo.getMaxDelay());
    }
}

