/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.buffer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.record.Record;

public abstract class AbstractBuffer<T extends Record<?>>
implements Buffer<T> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsWrittenCounter;
    private final Counter recordsReadCounter;
    private final AtomicLong recordsInFlight;
    private final AtomicLong recordsInBuffer;
    private final Counter recordsProcessedCounter;
    private final Counter writeTimeoutCounter;
    private final Counter recordsWriteFailed;
    private final Timer writeTimer;
    private final Timer latencyTimer;
    private final Timer readTimer;
    private final Timer checkpointTimer;
    private HeadlessPipeline failurePipeline;

    public AbstractBuffer(PluginSetting pluginSetting) {
        this(PluginMetrics.fromPluginSetting(pluginSetting), pluginSetting.getPipelineName());
    }

    public AbstractBuffer(String bufferName, String pipelineName) {
        this(PluginMetrics.fromNames(bufferName, pipelineName), pipelineName);
    }

    private AbstractBuffer(PluginMetrics pluginMetrics, String pipelineName) {
        this.pluginMetrics = pluginMetrics;
        this.recordsWrittenCounter = pluginMetrics.counter("recordsWritten");
        this.recordsReadCounter = pluginMetrics.counter("recordsRead");
        this.recordsInFlight = pluginMetrics.gauge("recordsInFlight", new AtomicLong());
        this.recordsInBuffer = pluginMetrics.gauge("recordsInBuffer", new AtomicLong());
        this.recordsProcessedCounter = pluginMetrics.counter("recordsProcessed", pipelineName);
        this.recordsWriteFailed = pluginMetrics.counter("recordsWriteFailed");
        this.writeTimeoutCounter = pluginMetrics.counter("writeTimeouts");
        this.writeTimer = pluginMetrics.timer("writeTimeElapsed");
        this.readTimer = pluginMetrics.timer("readTimeElapsed");
        this.latencyTimer = pluginMetrics.timer("readLatency");
        this.checkpointTimer = pluginMetrics.timer("checkpointTimeElapsed");
    }

    @Override
    public void setFailurePipeline(HeadlessPipeline failurePipeline) {
        this.failurePipeline = failurePipeline;
    }

    public HeadlessPipeline getFailurePipeline() {
        return this.failurePipeline;
    }

    @Override
    public void write(T record, int timeoutInMillis) throws TimeoutException {
        long startTime = System.nanoTime();
        try {
            this.doWrite(record, timeoutInMillis);
            if (!this.isByteBuffer()) {
                this.recordsWrittenCounter.increment();
                this.recordsInBuffer.incrementAndGet();
            }
            this.postProcess(this.recordsInBuffer.get());
        }
        catch (TimeoutException e) {
            this.recordsWriteFailed.increment();
            this.writeTimeoutCounter.increment();
            throw e;
        }
        finally {
            this.writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void writeAll(Collection<T> records, int timeoutInMillis) throws Exception {
        long startTime = System.nanoTime();
        int size = records.size();
        try {
            this.doWriteAll(records, timeoutInMillis);
            if (!this.isByteBuffer()) {
                this.recordsWrittenCounter.increment((double)size);
                this.recordsInBuffer.addAndGet(size);
            }
            this.postProcess(this.recordsInBuffer.get());
        }
        catch (Exception e) {
            this.recordsWriteFailed.increment((double)size);
            if (e instanceof TimeoutException) {
                this.writeTimeoutCounter.increment();
            }
            throw e;
        }
        finally {
            this.writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void writeBytes(byte[] bytes, String key, int timeoutInMillis) throws Exception {
        long startTime = System.nanoTime();
        try {
            this.doWriteBytes(bytes, key, timeoutInMillis);
            this.postProcess(this.recordsInBuffer.get());
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                this.writeTimeoutCounter.increment();
            }
            throw e;
        }
        finally {
            this.writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public Map.Entry<Collection<T>, CheckpointState> read(int timeoutInMillis) {
        Map.Entry readResult = (Map.Entry)this.readTimer.record(() -> this.doRead(timeoutInMillis));
        if (!this.isByteBuffer()) {
            this.recordsReadCounter.increment((double)((Collection)readResult.getKey()).size() * 1.0);
            this.recordsInFlight.addAndGet(((CheckpointState)readResult.getValue()).getNumRecordsToBeChecked());
            this.recordsInBuffer.addAndGet(-1 * ((CheckpointState)readResult.getValue()).getNumRecordsToBeChecked());
        }
        this.postProcess(this.recordsInBuffer.get());
        return readResult;
    }

    Timer getLatencyTimer() {
        return this.latencyTimer;
    }

    protected void updateLatency(Collection<T> records) {
        for (Record rec : records) {
            Object data;
            if (!(rec instanceof Record) || !((data = rec.getData()) instanceof Event)) continue;
            Event event = (Event)data;
            Instant receivedTime = event.getEventHandle().getInternalOriginationTime();
            this.latencyTimer.record(Duration.between(receivedTime, Instant.now()));
        }
    }

    @Override
    public void checkpoint(CheckpointState checkpointState) {
        this.checkpointTimer.record(() -> this.doCheckpoint(checkpointState));
        if (!this.isByteBuffer()) {
            int numRecordsToBeChecked = checkpointState.getNumRecordsToBeChecked();
            this.recordsInFlight.addAndGet(-numRecordsToBeChecked);
            this.recordsProcessedCounter.increment((double)numRecordsToBeChecked);
        }
    }

    public int getRecordsInFlight() {
        return this.recordsInFlight.intValue();
    }

    public abstract void doWrite(T var1, int var2) throws TimeoutException;

    public abstract void doWriteAll(Collection<T> var1, int var2) throws Exception;

    public void doWriteBytes(byte[] bytes, String key, int timeoutInMillis) throws Exception {
        throw new UnsupportedOperationException("Not supported: This is not a byte buffer.");
    }

    public abstract Map.Entry<Collection<T>, CheckpointState> doRead(int var1);

    public abstract void doCheckpoint(CheckpointState var1);

    @Override
    public abstract boolean isEmpty();

    public void postProcess(Long recordsInBuffer) {
    }
}

