/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.aws.api.AwsRequestSigningApache4Interceptor;
import org.opensearch.dataprepper.plugins.certificate.validation.PemObjectValidator;
import org.opensearch.dataprepper.plugins.source.opensearch.AuthConfig;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.truststore.TrustStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;

public class OpenSearchClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClientFactory.class);
    private static final String AOS_SERVICE_NAME = "es";
    private static final String AOSS_SERVICE_NAME = "aoss";
    private final AwsCredentialsSupplier awsCredentialsSupplier;

    public static OpenSearchClientFactory create(AwsCredentialsSupplier awsCredentialsSupplier) {
        return new OpenSearchClientFactory(awsCredentialsSupplier);
    }

    private OpenSearchClientFactory(AwsCredentialsSupplier awsCredentialsSupplier) {
        this.awsCredentialsSupplier = awsCredentialsSupplier;
    }

    public OpenSearchClient provideOpenSearchClient(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        OpenSearchTransport transport;
        if (Objects.nonNull(openSearchSourceConfiguration.getAwsAuthenticationOptions())) {
            transport = this.createOpenSearchTransportForAws(openSearchSourceConfiguration);
        } else {
            org.opensearch.client.RestClient restClient = this.createOpenSearchRestClient(openSearchSourceConfiguration);
            transport = this.createOpenSearchTransport(restClient);
        }
        return new OpenSearchClient(transport);
    }

    public ElasticsearchClient provideElasticSearchClient(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        RestClient restClientElasticsearch = this.createElasticSearchRestClient(openSearchSourceConfiguration);
        ElasticsearchTransport elasticsearchTransport = this.createElasticSearchTransport(restClientElasticsearch);
        return new ElasticsearchClient(elasticsearchTransport);
    }

    private OpenSearchTransport createOpenSearchTransport(org.opensearch.client.RestClient restClient) {
        return new org.opensearch.client.transport.rest_client.RestClientTransport(restClient, (org.opensearch.client.json.JsonpMapper)new JacksonJsonpMapper());
    }

    private OpenSearchTransport createOpenSearchTransportForAws(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        AwsCredentialsProvider awsCredentialsProvider = this.awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsRegion()).withStsRoleArn(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsRoleArn()).withStsExternalId(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsExternalId()).withStsHeaderOverrides(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsHeaderOverrides()).build());
        boolean isServerlessCollection = Objects.nonNull(openSearchSourceConfiguration.getAwsAuthenticationOptions()) && openSearchSourceConfiguration.getAwsAuthenticationOptions().isServerlessCollection() != false;
        return new AwsSdk2Transport(this.createSdkAsyncHttpClient(openSearchSourceConfiguration), HttpHost.create((String)openSearchSourceConfiguration.getHosts().get(0)).getHostName(), isServerlessCollection ? AOSS_SERVICE_NAME : AOS_SERVICE_NAME, openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsRegion(), AwsSdk2TransportOptions.builder().setCredentials(awsCredentialsProvider).setMapper((org.opensearch.client.json.JsonpMapper)new JacksonJsonpMapper()).build());
    }

    public SdkAsyncHttpClient createSdkAsyncHttpClient(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        if (Objects.nonNull(openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout())) {
            builder.connectionTimeout(openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout());
        }
        this.attachSSLContext(builder, openSearchSourceConfiguration);
        return builder.build();
    }

    private org.opensearch.client.RestClient createOpenSearchRestClient(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        List<String> hosts = openSearchSourceConfiguration.getHosts();
        HttpHost[] httpHosts = new HttpHost[hosts.size()];
        int i = 0;
        for (String host : hosts) {
            httpHosts[i] = HttpHost.create((String)host);
            ++i;
        }
        RestClientBuilder restClientBuilder = org.opensearch.client.RestClient.builder((HttpHost[])httpHosts);
        this.attachBasicAuth(restClientBuilder, openSearchSourceConfiguration);
        this.setConnectAndSocketTimeout(restClientBuilder, openSearchSourceConfiguration);
        return restClientBuilder.build();
    }

    private ElasticsearchTransport createElasticSearchTransport(RestClient restClient) {
        return new RestClientTransport(restClient, (JsonpMapper)new co.elastic.clients.json.jackson.JacksonJsonpMapper());
    }

    private RestClient createElasticSearchRestClient(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        List<String> hosts = openSearchSourceConfiguration.getHosts();
        HttpHost[] httpHosts = new HttpHost[hosts.size()];
        int i = 0;
        for (String host : hosts) {
            httpHosts[i] = HttpHost.create((String)host);
            ++i;
        }
        org.elasticsearch.client.RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Content-type", "application/json")});
        if (Objects.nonNull(openSearchSourceConfiguration.getAwsAuthenticationOptions())) {
            this.attachSigV4ForElasticsearchClient(restClientBuilder, openSearchSourceConfiguration);
        } else {
            this.attachBasicAuth(restClientBuilder, openSearchSourceConfiguration);
        }
        this.setConnectAndSocketTimeout(restClientBuilder, openSearchSourceConfiguration);
        return restClientBuilder.build();
    }

    private void attachSigV4ForElasticsearchClient(org.elasticsearch.client.RestClientBuilder restClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        AwsCredentialsProvider awsCredentialsProvider = this.awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsRegion()).withStsRoleArn(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsRoleArn()).withStsExternalId(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsExternalId()).withStsHeaderOverrides(openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsStsHeaderOverrides()).build());
        Aws4Signer aws4Signer = Aws4Signer.create();
        AwsRequestSigningApache4Interceptor httpRequestInterceptor = new AwsRequestSigningApache4Interceptor(AOS_SERVICE_NAME, (Signer)aws4Signer, awsCredentialsProvider, openSearchSourceConfiguration.getAwsAuthenticationOptions().getAwsRegion());
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$attachSigV4ForElasticsearchClient$1((HttpRequestInterceptor)httpRequestInterceptor, openSearchSourceConfiguration, arg_0));
    }

    private void attachBasicAuth(RestClientBuilder restClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (!openSearchSourceConfiguration.isAuthenticationDisabled().booleanValue()) {
                this.attachUsernameAndPassword(httpClientBuilder, openSearchSourceConfiguration);
            } else {
                LOG.warn("Authentication was explicitly disabled for the OpenSearch source");
            }
            this.attachSSLContext(httpClientBuilder, openSearchSourceConfiguration);
            return httpClientBuilder;
        });
    }

    private void attachBasicAuth(org.elasticsearch.client.RestClientBuilder restClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (!openSearchSourceConfiguration.isAuthenticationDisabled().booleanValue()) {
                this.attachUsernameAndPassword(httpClientBuilder, openSearchSourceConfiguration);
            } else {
                LOG.warn("Authentication was explicitly disabled for the OpenSearch source");
            }
            this.attachSSLContext(httpClientBuilder, openSearchSourceConfiguration);
            httpClientBuilder.addInterceptorLast((response, context) -> response.addHeader("X-Elastic-Product", "Elasticsearch"));
            return httpClientBuilder;
        });
    }

    private void setConnectAndSocketTimeout(RestClientBuilder restClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            if (Objects.nonNull(openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout())) {
                requestConfigBuilder.setConnectTimeout((int)openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout().toMillis());
            }
            if (Objects.nonNull(openSearchSourceConfiguration.getConnectionConfiguration().getSocketTimeout())) {
                requestConfigBuilder.setSocketTimeout((int)openSearchSourceConfiguration.getConnectionConfiguration().getSocketTimeout().toMillis());
            }
            return requestConfigBuilder;
        });
    }

    private void attachUsernameAndPassword(HttpAsyncClientBuilder httpClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        String password;
        String username;
        LOG.info("Using username and password for auth for the OpenSearch source");
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthConfig authConfig = openSearchSourceConfiguration.getAuthConfig();
        if (authConfig != null) {
            username = openSearchSourceConfiguration.getAuthConfig().getUsername();
            password = openSearchSourceConfiguration.getAuthConfig().getPassword();
        } else {
            username = openSearchSourceConfiguration.getUsername();
            password = openSearchSourceConfiguration.getPassword();
        }
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private void setConnectAndSocketTimeout(org.elasticsearch.client.RestClientBuilder restClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            if (Objects.nonNull(openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout())) {
                requestConfigBuilder.setConnectTimeout((int)openSearchSourceConfiguration.getConnectionConfiguration().getConnectTimeout().toMillis());
            }
            if (Objects.nonNull(openSearchSourceConfiguration.getConnectionConfiguration().getSocketTimeout())) {
                requestConfigBuilder.setSocketTimeout((int)openSearchSourceConfiguration.getConnectionConfiguration().getSocketTimeout().toMillis());
            }
            return requestConfigBuilder;
        });
    }

    private void attachSSLContext(NettyNioAsyncHttpClient.Builder asyncClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        TrustManager[] trustManagers = this.createTrustManagers(openSearchSourceConfiguration.getConnectionConfiguration());
        if (trustManagers.length > 0) {
            asyncClientBuilder.tlsTrustManagersProvider(() -> trustManagers);
        }
    }

    private void attachSSLContext(HttpAsyncClientBuilder httpClientBuilder, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        ConnectionConfiguration connectionConfiguration = openSearchSourceConfiguration.getConnectionConfiguration();
        SSLContext sslContext = this.getCAStrategy(connectionConfiguration);
        httpClientBuilder.setSSLContext(sslContext);
        if (connectionConfiguration.isInsecure()) {
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
    }

    private TrustManager[] createTrustManagers(ConnectionConfiguration connectionConfiguration) {
        Path certPath = connectionConfiguration.getCertPath();
        String certificate = connectionConfiguration.getCertificate();
        if (certPath != null) {
            return TrustStoreProvider.createTrustManager((Path)certPath);
        }
        if (certificate != null) {
            if (PemObjectValidator.isPemObject((String)certificate)) {
                return TrustStoreProvider.createTrustManager((String)certificate);
            }
            return TrustStoreProvider.createTrustManager((Path)Path.of(certificate, new String[0]));
        }
        if (connectionConfiguration.isInsecure()) {
            return TrustStoreProvider.createTrustAllManager();
        }
        return new TrustManager[0];
    }

    private SSLContext getCAStrategy(ConnectionConfiguration connectionConfiguration) {
        Path certPath = connectionConfiguration.getCertPath();
        String certificate = connectionConfiguration.getCertificate();
        if (certPath != null) {
            return TrustStoreProvider.createSSLContext((Path)certPath);
        }
        if (certificate != null) {
            if (PemObjectValidator.isPemObject((String)certificate)) {
                return TrustStoreProvider.createSSLContext((String)certificate);
            }
            return TrustStoreProvider.createSSLContext((Path)Path.of(connectionConfiguration.getCertificate(), new String[0]));
        }
        if (connectionConfiguration.isInsecure()) {
            return TrustStoreProvider.createSSLContextWithTrustAllStrategy();
        }
        return null;
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$attachSigV4ForElasticsearchClient$1(HttpRequestInterceptor httpRequestInterceptor, OpenSearchSourceConfiguration openSearchSourceConfiguration, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.addInterceptorLast(httpRequestInterceptor);
        this.attachSSLContext(httpClientBuilder, openSearchSourceConfiguration);
        httpClientBuilder.addInterceptorLast((response, context) -> response.addHeader("X-Elastic-Product", "Elasticsearch"));
        return httpClientBuilder;
    }
}

