/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.ScoreSort;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.ClearScrollResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.pit.CreatePitRequest;
import org.opensearch.client.opensearch.core.pit.CreatePitResponse;
import org.opensearch.client.opensearch.core.pit.DeletePitRecord;
import org.opensearch.client.opensearch.core.pit.DeletePitRequest;
import org.opensearch.client.opensearch.core.pit.DeletePitResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.Pit;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.plugin.PluginComponentRefresher;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.ClusterClientFactory;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.exceptions.IndexNotFoundException;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.exceptions.SearchContextLimitException;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreatePointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreatePointInTimeResponse;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreateScrollRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreateScrollResponse;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.DeletePointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.DeleteScrollRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.NoSearchContextSearchRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchContextType;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchPointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchScrollRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchScrollResponse;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchWithSearchAfterResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchAccessor
implements SearchAccessor,
ClusterClientFactory<OpenSearchClient> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchAccessor.class);
    static final String PIT_RESOURCE_LIMIT_ERROR_TYPE = "rejected_execution_exception";
    static final String INDEX_NOT_FOUND_EXCEPTION = "index_not_found_exception";
    static final String SCROLL_RESOURCE_LIMIT_EXCEPTION_MESSAGE = "Trying to create too many scroll contexts";
    private final PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration> clientRefresher;
    private final SearchContextType searchContextType;

    public OpenSearchAccessor(PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration> clientRefresher, SearchContextType searchContextType) {
        this.clientRefresher = clientRefresher;
        this.searchContextType = searchContextType;
    }

    @Override
    public SearchContextType getSearchContextType() {
        return this.searchContextType;
    }

    @Override
    public CreatePointInTimeResponse createPit(CreatePointInTimeRequest createPointInTimeRequest) {
        CreatePitResponse createPitResponse;
        try {
            createPitResponse = ((OpenSearchClient)this.clientRefresher.get()).createPit(CreatePitRequest.of(builder -> builder.targetIndexes(createPointInTimeRequest.getIndex(), new String[0]).keepAlive((Time)new Time.Builder().time(createPointInTimeRequest.getKeepAlive()).build())));
        }
        catch (OpenSearchException e) {
            if (this.isDueToPitLimitExceeded(e)) {
                throw new SearchContextLimitException(String.format("There was an error creating a new point in time for index '%s': %s", createPointInTimeRequest.getIndex(), e.error().causedBy().reason()));
            }
            if (this.isDueToNoIndexFound(e)) {
                throw new IndexNotFoundException(String.format("The index '%s' could not be found and may have been deleted", createPointInTimeRequest.getIndex()));
            }
            LOG.error("There was an error creating a point in time for OpenSearch: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("There was an error creating a point in time for OpenSearch: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return CreatePointInTimeResponse.builder().withPitId(createPitResponse.pitId()).withCreationTime(createPitResponse.creationTime()).build();
    }

    @Override
    public SearchWithSearchAfterResults searchWithPit(SearchPointInTimeRequest searchPointInTimeRequest) {
        SearchRequest searchRequest = SearchRequest.of(builder -> {
            builder.pit(Pit.of(pitBuilder -> pitBuilder.id(searchPointInTimeRequest.getPitId()).keepAlive(searchPointInTimeRequest.getKeepAlive()))).size(searchPointInTimeRequest.getPaginationSize()).sort(List.of(SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.doc(ScoreSort.of(scoreSort -> scoreSort.order(SortOrder.Asc)))), SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.field(FieldSort.of(fieldSort -> fieldSort.field("_id").order(SortOrder.Asc)))))).version(Boolean.valueOf(true)).query(Query.of(query -> query.matchAll(MatchAllQuery.of(matchAllQuery -> matchAllQuery))));
            if (Objects.nonNull(searchPointInTimeRequest.getSearchAfter())) {
                builder.searchAfter(searchPointInTimeRequest.getSearchAfter());
            }
            return builder;
        });
        return this.searchWithSearchAfter(searchRequest);
    }

    @Override
    public void deletePit(DeletePointInTimeRequest deletePointInTimeRequest) {
        try {
            DeletePitResponse deletePitResponse = ((OpenSearchClient)this.clientRefresher.get()).deletePit(DeletePitRequest.of(builder -> builder.pitId(Collections.singletonList(deletePointInTimeRequest.getPitId()))));
            if (this.isPitDeletedSuccessfully(deletePitResponse)) {
                LOG.debug("Successfully deleted point in time id {}", (Object)deletePointInTimeRequest.getPitId());
            } else {
                LOG.warn("Point in time id {} was not deleted successfully. It will expire from keep-alive", (Object)deletePointInTimeRequest.getPitId());
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("There was an error deleting the point in time with id {} for OpenSearch. It will expire from keep-alive: ", (Object)deletePointInTimeRequest.getPitId(), (Object)e);
        }
    }

    @Override
    public CreateScrollResponse createScroll(CreateScrollRequest createScrollRequest) {
        SearchResponse searchResponse;
        try {
            searchResponse = ((OpenSearchClient)this.clientRefresher.get()).search(SearchRequest.of(request -> request.scroll(Time.of(time -> time.time(createScrollRequest.getScrollTime()))).sort(SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.doc(ScoreSort.of(scoreSort -> scoreSort.order(SortOrder.Asc)))), new SortOptions[0]).size(createScrollRequest.getSize()).version(Boolean.valueOf(true)).index(createScrollRequest.getIndex(), new String[0])), ObjectNode.class);
        }
        catch (OpenSearchException e) {
            if (this.isDueToNoIndexFound(e)) {
                throw new IndexNotFoundException(String.format("The index '%s' could not be found and may have been deleted", createScrollRequest.getIndex()));
            }
            LOG.error("There was an error creating a scroll context for OpenSearch: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("There was an error creating a scroll context for OpenSearch: ", (Throwable)e);
            if (this.isDueToScrollLimitExceeded(e)) {
                throw new SearchContextLimitException(String.format("There was an error creating a new scroll context for index '%s': %s", createScrollRequest.getIndex(), e.getMessage()));
            }
            throw new RuntimeException(e);
        }
        return CreateScrollResponse.builder().withCreationTime(Instant.now().toEpochMilli()).withScrollId(searchResponse.scrollId()).withDocuments(this.getDocumentsFromResponse((SearchResponse<ObjectNode>)searchResponse)).build();
    }

    @Override
    public SearchScrollResponse searchWithScroll(SearchScrollRequest searchScrollRequest) {
        ScrollResponse searchResponse;
        try {
            searchResponse = ((OpenSearchClient)this.clientRefresher.get()).scroll(ScrollRequest.of(request -> request.scrollId(searchScrollRequest.getScrollId()).scroll(Time.of(time -> time.time(searchScrollRequest.getScrollTime())))), ObjectNode.class);
        }
        catch (OpenSearchException e) {
            LOG.error("There was an error searching with a scroll context for OpenSearch: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("There was an error searching with a scroll context for OpenSearch: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return SearchScrollResponse.builder().withScrollId(searchResponse.scrollId()).withDocuments(this.getDocumentsFromResponse((SearchResponse<ObjectNode>)searchResponse)).build();
    }

    @Override
    public void deleteScroll(DeleteScrollRequest deleteScrollRequest) {
        try {
            ClearScrollResponse clearScrollResponse = ((OpenSearchClient)this.clientRefresher.get()).clearScroll(ClearScrollRequest.of(request -> request.scrollId(deleteScrollRequest.getScrollId(), new String[0])));
            if (clearScrollResponse.succeeded()) {
                LOG.debug("Successfully deleted scroll context with id {}", (Object)deleteScrollRequest.getScrollId());
            } else {
                LOG.warn("Scroll context with id {} was not deleted successfully. It will expire from timing out on its own", (Object)deleteScrollRequest.getScrollId());
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("There was an error deleting the scroll context with id {} for OpenSearch. It will expire from timing out : ", (Object)deleteScrollRequest.getScrollId(), (Object)e);
        }
    }

    @Override
    public SearchWithSearchAfterResults searchWithoutSearchContext(NoSearchContextSearchRequest noSearchContextSearchRequest) {
        SearchRequest searchRequest = SearchRequest.of(builder -> {
            builder.index(noSearchContextSearchRequest.getIndex(), new String[0]).size(noSearchContextSearchRequest.getPaginationSize()).sort(List.of(SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.doc(ScoreSort.of(scoreSort -> scoreSort.order(SortOrder.Asc)))), SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.field(FieldSort.of(fieldSort -> fieldSort.field("_id").order(SortOrder.Asc)))))).version(Boolean.valueOf(true)).query(Query.of(query -> query.matchAll(MatchAllQuery.of(matchAllQuery -> matchAllQuery))));
            if (Objects.nonNull(noSearchContextSearchRequest.getSearchAfter())) {
                builder.searchAfter(noSearchContextSearchRequest.getSearchAfter());
            }
            return builder;
        });
        return this.searchWithSearchAfter(searchRequest);
    }

    @Override
    public PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration> getClientRefresher() {
        return this.clientRefresher;
    }

    private boolean isPitDeletedSuccessfully(DeletePitResponse deletePitResponse) {
        return Objects.nonNull(deletePitResponse.pits()) && deletePitResponse.pits().size() == 1 && Objects.nonNull(deletePitResponse.pits().get(0)) && ((DeletePitRecord)deletePitResponse.pits().get(0)).successful() != false;
    }

    private boolean isDueToPitLimitExceeded(OpenSearchException e) {
        return Objects.nonNull(e.error()) && Objects.nonNull(e.error().causedBy()) && Objects.nonNull(e.error().causedBy().type()) && PIT_RESOURCE_LIMIT_ERROR_TYPE.equals(e.error().causedBy().type());
    }

    private boolean isDueToNoIndexFound(OpenSearchException e) {
        return Objects.nonNull(e.response()) && Objects.nonNull(e.response().error()) && Objects.nonNull(e.response().error().type()) && INDEX_NOT_FOUND_EXCEPTION.equals(e.response().error().type());
    }

    private boolean isDueToScrollLimitExceeded(IOException e) {
        return e.getMessage().contains(SCROLL_RESOURCE_LIMIT_EXCEPTION_MESSAGE);
    }

    private SearchWithSearchAfterResults searchWithSearchAfter(SearchRequest searchRequest) {
        try {
            SearchResponse searchResponse = ((OpenSearchClient)this.clientRefresher.get()).search(searchRequest, ObjectNode.class);
            List<Event> documents = this.getDocumentsFromResponse((SearchResponse<ObjectNode>)searchResponse);
            List nextSearchAfter = Objects.nonNull(searchResponse.hits().hits()) && !searchResponse.hits().hits().isEmpty() ? ((Hit)searchResponse.hits().hits().get(searchResponse.hits().hits().size() - 1)).sort() : null;
            return SearchWithSearchAfterResults.builder().withDocuments(documents).withNextSearchAfter(nextSearchAfter).build();
        }
        catch (OpenSearchException e) {
            LOG.error(e.getMessage());
            if (this.isDueToNoIndexFound(e)) {
                throw new IndexNotFoundException(String.format("The index '%s' could not be found and may have been deleted", searchRequest.index()));
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Event> getDocumentsFromResponse(SearchResponse<ObjectNode> searchResponse) {
        return searchResponse.hits().hits().stream().map(hit -> JacksonEvent.builder().withData(hit.source()).withEventMetadataAttributes(Map.of("opensearch-document_id", hit.id(), "opensearch-index", hit.index(), "opensearch_document_version", hit.version())).withEventType(EventType.DOCUMENT.toString()).build()).collect(Collectors.toList());
    }
}

