/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class OpenSearchIndexProgressState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String pitId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long pitCreationTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long keepAlive;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> searchAfter;

    public OpenSearchIndexProgressState() {
    }

    @JsonCreator
    public OpenSearchIndexProgressState(@JsonProperty(value="pit_id") String pitId, @JsonProperty(value="pit_creation_time") Long pitCreationTime, @JsonProperty(value="pit_keep_alive") Long pitKeepAlive, @JsonProperty(value="pit_search_after") List<String> searchAfter) {
        this.pitId = pitId;
        this.pitCreationTime = pitCreationTime;
        this.keepAlive = pitKeepAlive;
        this.searchAfter = searchAfter;
    }

    public List<String> getSearchAfter() {
        return this.searchAfter;
    }

    public void setSearchAfter(List<String> searchAfter) {
        this.searchAfter = searchAfter;
    }

    public String getPitId() {
        return this.pitId;
    }

    public void setPitId(String pitId) {
        this.pitId = pitId;
    }

    public Long getPitCreationTime() {
        return this.pitCreationTime;
    }

    public void setPitCreationTime(Long pitCreationTime) {
        this.pitCreationTime = pitCreationTime;
    }

    public Long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean hasValidPointInTime() {
        return Objects.nonNull(this.pitId) && Objects.nonNull(this.pitCreationTime) && Objects.nonNull(this.keepAlive) && Instant.ofEpochMilli(this.pitCreationTime + this.keepAlive).isAfter(Instant.now());
    }
}

