/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum IndexType {
    TRACE_ANALYTICS_RAW("trace-analytics-raw"),
    TRACE_ANALYTICS_RAW_PLAIN("trace-analytics-plain-raw"),
    TRACE_ANALYTICS_SERVICE_MAP("trace-analytics-service-map"),
    OTEL_APM_SERVICE_MAP("otel-v2-apm-service-map"),
    LOG_ANALYTICS("log-analytics"),
    LOG_ANALYTICS_PLAIN("log-analytics-plain"),
    METRIC_ANALYTICS("metric-analytics"),
    METRIC_ANALYTICS_PLAIN("metric-analytics-plain"),
    CUSTOM("custom"),
    MANAGEMENT_DISABLED("management_disabled");

    private final String value;
    private static final Map<String, IndexType> STRING_TO_INDEX_TYPE_MAP;

    private IndexType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static Optional<IndexType> getByValue(String value) {
        return Optional.ofNullable(STRING_TO_INDEX_TYPE_MAP.get(value));
    }

    static String getIndexTypeValues() {
        return Arrays.stream(IndexType.values()).map(IndexType::getValue).collect(Collectors.toList()).toString();
    }

    static {
        STRING_TO_INDEX_TYPE_MAP = new HashMap<String, IndexType>();
        Arrays.stream(IndexType.values()).forEach(indexType -> STRING_TO_INDEX_TYPE_MAP.put(indexType.value, (IndexType)((Object)indexType)));
    }
}

