/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.indices.ExistsTemplateRequest;
import org.opensearch.client.opensearch.indices.GetTemplateRequest;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.OpenSearchIndicesClient;
import org.opensearch.client.opensearch.indices.PutTemplateRequest;
import org.opensearch.client.opensearch.indices.PutTemplateResponse;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.LegacyIndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.PutTemplateRequestDeserializer;

public class Es6IndexTemplateAPIWrapper
implements IndexTemplateAPIWrapper<GetTemplateResponse> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OpenSearchClient openSearchClient;

    public Es6IndexTemplateAPIWrapper(OpenSearchClient openSearchClient) {
        this.openSearchClient = openSearchClient;
    }

    @Override
    public void putTemplate(IndexTemplate indexTemplate) throws IOException {
        if (!(indexTemplate instanceof LegacyIndexTemplate)) {
            throw new IllegalArgumentException("Unexpected indexTemplate provided to createTemplate.");
        }
        Map<String, Object> templateMapping = ((LegacyIndexTemplate)indexTemplate).getTemplateMap();
        String indexTemplateString = OBJECT_MAPPER.writeValueAsString(templateMapping);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(indexTemplateString.getBytes(StandardCharsets.UTF_8));
        JsonpMapper mapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
        JsonParser parser = mapper.jsonProvider().createParser((InputStream)byteIn);
        PutTemplateRequest putTemplateRequest = (PutTemplateRequest)PutTemplateRequestDeserializer.getJsonpDeserializer().deserialize(parser, mapper);
        OpenSearchIndicesClient openSearchIndicesClient = this.openSearchClient.indices();
        JsonEndpoint<PutTemplateRequest, PutTemplateResponse, ErrorResponse> endpoint = this.es6PutTemplateEndpoint(putTemplateRequest);
        ((OpenSearchTransport)openSearchIndicesClient._transport()).performRequest((Object)putTemplateRequest, endpoint, openSearchIndicesClient._transportOptions());
    }

    @Override
    public Optional<GetTemplateResponse> getTemplate(String templateName) throws IOException {
        ExistsTemplateRequest existsTemplateRequest = new ExistsTemplateRequest.Builder().name(templateName, new String[0]).build();
        BooleanResponse booleanResponse = this.openSearchClient.indices().existsTemplate(existsTemplateRequest);
        if (!booleanResponse.value()) {
            return Optional.empty();
        }
        GetTemplateRequest getTemplateRequest = new GetTemplateRequest.Builder().name(templateName, new String[0]).build();
        return Optional.of(this.openSearchClient.indices().getTemplate(getTemplateRequest));
    }

    private JsonEndpoint<PutTemplateRequest, PutTemplateResponse, ErrorResponse> es6PutTemplateEndpoint(PutTemplateRequest putTemplateRequest) {
        return new SimpleEndpoint(request -> "PUT", request -> {
            boolean _name = true;
            boolean propsSet = false;
            if (propsSet |= true) {
                StringBuilder buf = new StringBuilder();
                buf.append("/_template");
                buf.append("/");
                SimpleEndpoint.pathEncode((String)request.name(), (StringBuilder)buf);
                buf.append("?include_type_name=false");
                return buf.toString();
            }
            throw SimpleEndpoint.noPathTemplateFound((String)"path");
        }, request -> {
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.masterTimeout() != null) {
                params.put("master_timeout", request.masterTimeout()._toJsonString());
            }
            if (request.clusterManagerTimeout() != null) {
                params.put("cluster_manager_timeout", request.clusterManagerTimeout()._toJsonString());
            }
            if (request.flatSettings() != null) {
                params.put("flat_settings", String.valueOf(request.flatSettings()));
            }
            if (request.create() != null) {
                params.put("create", String.valueOf(request.create()));
            }
            if (request.timeout() != null) {
                params.put("timeout", request.timeout()._toJsonString());
            }
            return params;
        }, SimpleEndpoint.emptyMap(), true, PutTemplateResponse._DESERIALIZER);
    }
}

